package org.maachang.comet.down ;

/**
 * シャットダウンフック.
 *
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public abstract class ShutdownCallback {
    
    /**
     * シャットダウン実行フラグ.
     */
    protected volatile boolean isShutdown = false ;
    
    /**
     * 同期オブジェクト.
     */
    protected final Object sync = new Object() ;
    
    /**
     * シャットダウン実行フラグを取得.
     * <BR>
     * @return boolean [true]の場合、既に実行されました.
     */
    public boolean isShutdown() {
        boolean ret = false ;
        synchronized( sync ) {
            ret = this.isShutdown ;
        }
        return ret ;
    }
    
    /**
     * シャットダウン完了フラグを設定.
     */
    protected void exitShutdown() {
        synchronized( sync ) {
            this.isShutdown = true ;
        }
    }
    
    /**
     * シャットダウン実行.
     * <BR><BR>
     * シャットダウンを実行するコールバックメソッド.
     */
    public abstract void execution() ;
    
}
