package org.maachang.comet.httpd ;

import java.io.OutputStream;

/**
 * １つのコネクションオブジェクト.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpConnectionInfo {
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * コネクションオブジェクトを破棄します.
     */
    public void destroy() ;
    
    /**
     * コネクションキャンセル.
     * <BR><BR>
     * コネクション処理をキャンセルします.
     */
    public void cancel() ;
    
    /**
     * Httpソケットを取得.
     * <BR>
     * @return HttpSocket HttpSocketが返されます.
     */
    public HttpSocket getSocket() ;
    
    /**
     * KeepAliveタイムアウトを設定.
     * <BR>
     * @param KeepAliveタイムアウト値を設定します.
     */
    public void setTimeout( long timeout ) ;
    
    /**
     * KeepAliveカウントを設定.
     * <BR>
     * @param count KeepAliveカウント値をミリ秒で設定します.
     */
    public void setCount( int count ) ;
    
    /**
     * KeepAliveタイムアウト値を取得.
     * <BR><BR>
     * @return long KeepAliveタイムアウト値がミリ秒単位で返されます.
     */
    public long getTimeout() ;
    
    /**
     * KeepAliveカウントを取得.
     * <BR><BR>
     * @return int KeepAliveカウント値が返されます.
     */
    public int getCount() ;
    
    /**
     * コネクション更新.
     * <BR>
     * @exception Exception 例外.
     */
    public void update() throws Exception ;
    
    /**
     * コネクション再利用.
     */
    public boolean recyclingConnection() ;
    
    /**
     * タイマー初期値に設定.
     */
    public void resetTimer() ;
    
    /**
     * 最終利用時間が返されます.
     * <BR>
     * @return long 最終利用時間が返されます.
     */
    public long getTimer() ;
    
    /**
     * 送信用ストリームを取得.
     * <BR>
     * @return OutputStream 送信用ストリームが返されます.
     */
    public OutputStream getOutputStream()
        throws Exception ;
    
    /**
     * コネクションクローズを設定.
     * <BR>
     * @param mode [true]の場合、オブジェクト利用後に
     *             コネクションをクローズするか設定します.
     */
    public void setCloseFlag( boolean mode ) ;
    
    /**
     * コネクションクローズを取得.
     * <BR>
     * @return boolean [true]の場合、コネクションクローズを行います.
     */
    public boolean isCloseFlag() ;
    
    /**
     * 送信用ストリームが生成されているかチェック.
     * <BR>
     * @return boolean [true]の場合、送信ストリームが生成されています.
     */
    public boolean isOutputStream() ;
    
    /**
     * オブジェクトが有効かチェック.
     * <BR>
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() ;
}
