//
// HTMLタグスクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// メッセージタグ.
////////////////////////////////////////////////////////////////////////////////

// Validateエラーメッセージ表示用タグ.
errorTag = function(id) {
    if( __$type$script == "script" ) {
        if( isNull( id ) ) {
            id = 0 ;
        }
        if( useString( _$script$query.get('_validateError'+id) ) == true ) {
            return "<div id=\"emsgId\" class=\"emsg\" style=\"color:red;\">"+
                _$script$query.get('_validateError'+id) + 
                "</div>" ;
        }
        else {
            return "<div id=\"emsgId\" class=\"emsg\" style=\"color:red;\"></div>" ;
        }
    }
    return "" ;
} ;

// 正常メッセージ表示用タグ.
successTag = function(id) {
    if( __$type$script == "script" ) {
        if( isNull( id ) ) {
            id = 0 ;
        }
        if( useString( _$script$query.get('_validateSuccess'+id) ) == true ) {
            return "<div id=\"smsgId\" class=\"smsg\" style=\"color:blue;\">"+
                _$script$query.get('_validateSuccess'+id) + 
                "</div>" ;
        }
        else {
            return "<div id=\"smsgId\" class=\"smsg\" style=\"color:blue;\"></div>" ;
        }
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// HTMLタグ関連.
////////////////////////////////////////////////////////////////////////////////

// Inputタグの名前保存用.
var _$tagInputNames = [] ;

// 現在のパラメータをhiddenタグに付加.
outputHiddenQuery = function() {
    var map = _$script$query ;
    var o = map.keySet().toArray() ;
    var len = o.length ;
    var ret = "" ;
    for( var i = 0 ; i < len ; i ++ ) {
        var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
        if( isNull( one ) || startsWith( one,"_" ) || startsWith( one,"$" ) ) {
            continue ;
        }
        ret += hiddenTag( one ) ;
    }
    return ret ;
}

// その他情報を展開.
etcTag = function( etc ) {
    if( isNull( etc ) ) {
        return "" ;
    }
    if( typeof( etc ) == "string" || etc instanceof String ) {
        return " "+etc+" " ;
    }
    var ret = " " ;
    for( var k in etc ) {
        if( isNull( etc[k] ) == false && useString( etc[k] ) == true ) {
            ret += "" + k + "=" + "\""+etc[k]+"\" " ;
        }
    }
    return ret ;
} ;

// リンク指定時に利用.
viewHref = function(href) {
    var p = -1 ;
    if( ( p = href.indexOf( "?" ) ) == -1 ) {
        if( isSessionLink() == false && getSessionId() != null ) {
            href += "?t=" + new Date().getTime() + "&"+sessionParam()+"="+getSessionId() ;
        }
        else {
            href += "?t=" + new Date().getTime() ;
        }
    }
    else {
        var a = href.substring( 0,p ) ;
        var b = href.substring( p+1 ) ;
        if( b.indexOf( "%" ) == -1 ) {
            b = urlEncode( b ) ;
        }
        if( isSessionLink() == false && getSessionId() != null ) {
            href = a + "?t=" + new Date().getTime() + "&"+sessionParam()+"="+getSessionId() + "&" + b ;
        }
        else {
            href = a + "?t=" + new Date().getTime() +"&" + b ;
        }
        a = null ;
        b = null ;
    }
    p = null ;
    return margePathName(href) ;
}

// 現在のカレント名から、フォーム名を生成.
getFormNameByCurrentName = function() {
    var ret = currentName() ;
    var p = ret.lastIndexOf( "/" ) ;
    if( p >= 0 ) {
        ret = ret.substring( p+1 ) ;
    }
    p = ret.indexOf( "." ) ;
    if( p >= 0 ) {
        ret = ret.substring( 0,p ) ;
    }
    ret = trim( ret ) ;
    if( endsWith( ret,"Controller" ) ) {
        ret = ret.substring( 0,ret.length - "Controller".length ) ;
    }
    ret += "Form" ;
    return ret ;
}

// charset定義.
charsetTag = function(charset,mime) {
    if( __$type$script == "script" ) {
        if( useString( charset ) == false ) {
            charset = "utf-8" ;
        }
        charset = trim( charset ) ;
        if( useString( mime ) == false ) {
            mime = "text/html" ;
        }
        if( endsWith( mime,";" ) == false ) {
            mime += ";" ;
        }
        return "<meta http-equiv=\"content-type\" content=\""+mime+" charset="+charset+"\">" ;
    }
    return "" ;
} ;

// favicon.ico表示設定用.
iconTag = function(path) {
    if( __$type$script == "script" ) {
        if( useString( path ) == false ) {
            path = "/" ;
        }
        path = trim( path ) ;
        if( path.length > 0 && startsWith( path,"/" ) == false ) {
            path += "/" ;
        }
        if( path.length > 0 && endsWith( path,"/" ) == false ) {
            path += "/" ;
        }
        return "<link rel=\"shortcut icon\" href=\"" + path +
            "favicon.ico"+"?"+java.lang.System.currentTimeMillis()+"\">" ;
    }
    return "" ;
} ;

// JavaScript読み込み用タグ.
scriptTag = function(name) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            return "<script language=\"javascript\" type=\"text/javascript\" src=\""+name+
                "?"+java.lang.System.currentTimeMillis()+"\"></script>" ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            return "<script language=\"javascript\" type=\"text/javascript\" src=\"/js/"+name+
                "?"+java.lang.System.currentTimeMillis()+"\"></script>" ;
        }
    }
    return "" ;
} ;

// CSS読み込み用タグ.
styleTag = function(name) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            return "<link rel=\"stylesheet\" href=\""+name+"?"+
                java.lang.System.currentTimeMillis()+"\" type=\"text/css\"/>" ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            return "<link rel=\"stylesheet\" href=\"/style/"+name+"?"+
                java.lang.System.currentTimeMillis()+"\" type=\"text/css\"/>" ;
        }
    }
    return "" ;
} ;

// 通常のimage読み込み用タグ.
imageTag = function(name,alt,border,width,height,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            var ret = "<img src=\""+name+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            var ret = "<img src=\"/img/"+name+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ImageOp読み込み用タグ.
imageOpTag = function(imageId,addParam,alt,border,width,height,etc) {
    if( isNull( imageId ) == false && isNumeric( imageId ) == true &&
        __$type$script == "script" ) {
        var ret = "<img src=\"/%00i%00m%00g_"+imageId+"?"+java.lang.System.currentTimeMillis() ;
        if( isNull( addParam ) == false ) {
            ret += "&" + addParam ;
        }
        ret += +"\"" ;
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像サーバ側生成用img読み込みタグ.
serverImgTag = function(name,alt,border,width,height,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        name=viewHref(name) ;
        var ret = "<img src=\""+name+"\"" ;
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// DIVタグ.
idTag = function( id,etc ) {
    if( useString( id ) == true && __$type$script == "script" ) {
        var ret = "" ;
        ret += "<div id=\"" + id + "\" " ;
        ret += etcTag( etc ) ;
        ret += ">&nbsp;</div>" ;
        return ret ;
    }
    return "" ;
} ;

// リンクタグ.
linkTag = function( href,view,etc ) {
    if( useString( href ) == true && __$type$script == "script" ) {
        var ret = "" ;
        href = viewHref(href) ;
        ret += "<a href=\""+href+"\" " ;
        ret += etcTag( etc ) ;
        ret += ">" ;
        if( useString( view ) ) {
            ret += view ;
        }
        return ret + "</a>" ;
    }
    return "" ;
} ;

// 開始リンクタグ.
startLinkTag = function( href,etc ) {
    if( useString( href ) == true && __$type$script == "script" ) {
        var ret = "" ;
        href = viewHref(href) ;
        ret += "<a href=\""+href+"\" " ;
        ret += etcTag( etc ) ;
        ret += ">" ;
        return ret ;
    }
    return "" ;
} ;

// 終了リンクタグ.
endLinkTag = function() {
    if( __$type$script == "script" ) {
        return "<a>" ;
    }
    return "" ;
}


// form開始タグ.
startForm = function( action,name,method,etc ) {
    if( useString( action ) == true && __$type$script == "script" ) {
        var ret = "" ;
        if( useString( method ) == false ) {
            method = "POST" ;
        }
        ret += "<form " + "method=\"" + method + "\" action=\"" + margePathName(action) + "\" " ;
        if( useString( name ) ) {
            ret += "name=\""+name+"\" " ;
        }
        else {
            name = getFormNameByCurrentName() ;
            ret += "name=\""+name+"\" " ;
        }
        ret += etcTag( etc ) ;
        if( isSessionLink() == false && getSessionId() != null ) {
            ret += ">\n" + "<input type=\"hidden\" name=\""+sessionParam()+"\" value=\""+getSessionId()+"\">" ;
        }
        else {
            ret += ">" ;
        }
        // inputタグ系の情報を初期化.
        _$tagInputNames = [] ;
        return ret ;
    }
    return "" ;
} ;

// MultiPartForm開始タグ.
multiForm = function( action,name,etc ) {
    if( useString( action ) == true && __$type$script == "script" ) {
        var ret = "" ;
        ret += "<form " + "method=\"POST\" action=\"" + margePathName(action) + "\" enctype=\"multipart/form-data\" " ;
        if( useString( name ) ) {
            ret += "name=\""+name+"\" " ;
        }
        else {
            name = getFormNameByCurrentName() ;
            ret += "name=\""+name+"\" " ;
        }
        ret += etcTag( etc ) ;
        if( isSessionLink() == false && getSessionId() != null ) {
            ret += ">\n" + "<input type=\"hidden\" name=\""+sessionParam()+"\" value=\""+getSessionId()+"\">" ;
        }
        else {
            ret += ">" ;
        }
        // inputタグ系の情報を初期化.
        _$tagInputNames = [] ;
        return ret ;
    }
    return "" ;
} ;

// 終了タグ.
endForm = function(mode) {
    if( __$type$script == "script" ) {
        if( isNull( mode ) == false && mode == true ) {
            var map = _$script$query ;
            var o = map.keySet().toArray() ;
            var len = o.length ;
            var ret = "" ;
            for( var i = 0 ; i < len ; i ++ ) {
                var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                if( isNull( one ) || startsWith( one,"_" ) || startsWith( one,"$" ) ) {
                    continue ;
                }
                else {
                    var lenJ = _$tagInputNames.length ;
                    var flg = false ;
                    for( var j = 0 ; j < lenJ ; j ++ ) {
                        if( _$tagInputNames[ j ] == one ) {
                            flg = true ;
                            break ;
                        }
                    }
                    if( flg == true ) {
                        continue ;
                    }
                }
                ret += hiddenTag( one ) ;
            }
            _$tagInputNames = [] ;
            return ret + "</form>" ;
        }
        else {
            _$tagInputNames = [] ;
            return "</form>" ;
        }
    }
    return "" ;
} ;

// submitボタン.
submitButton = function( value ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"submit\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        return ret + ">" ;
    }
    return "" ;
} ;

// resetボタン.
resetButton = function( value ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"reset\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像ボタン.
imgButton = function(name,src,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像リンクボタン.
imgLinkButton = function(name,src,href,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( href ) ) {
            href = viewHref(href) ;
            ret += " onclick=\"location.href='"+href+"'\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像Submitボタン.
imgSubmitButton = function(name,src,formName,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        ret += " onclick=\"document."+formName+".submit()\"" ;
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像リセットボタン.
imgResetButton = function(name,src,formName,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( formName ) ) {
            ret += " onclick=\"document."+formName+".reset()\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ボタン.
button = function( value,etc ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"button\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// リンクボタン.
linkButton = function( value,href,etc ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"button\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        if( useString( href ) ) {
            href = viewHref(href) ;
            ret += " onclick=\"location.href='"+href+"'\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// Hiddenタグ.
hiddenTag = function(name,value,id,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        var tmp = "<input type=\"hidden\" name=\""+name+"\" " ;
        tmp += etcTag( etc ) ;
        if( useString( id ) ) {
            tmp += "id=\""+id+"\" " ;
        }
        var ret = "" ;
        if( useString( value ) == true ) {
            ret = tmp + "value=\""+ value + "\" >\n" ;
        }
        else {
            var val = _$script$query.get( name ) ;
            if( isNull( val ) == false ) {
                if( val instanceof java.lang.String ) {
                    ret = tmp + "value=\""+ val + "\" >\n" ;
                }
                else if( val instanceof java.util.List ) {
                    var len = val.size() ;
                    for( var i = 0 ; i < len ; i ++ ) {
                        ret += tmp + "value=\""+ val.get( i ) + "\" >\n" ;
                    }
                }
            }
            if( useString( ret ) == false ) {
                ret = tmp + " >\n" ;
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret ;
    }
    return "" ;
} ;

// テキストエリアタグ.
textAreaTag = function(name,id,clazz,cols,rows,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        var ret = "<textarea name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( cols ) ) {
            ret += "cols=\""+cols+"\" " ;
        }
        if( isNumeric( rows ) ) {
            ret += "rows=\""+rows+"\" " ;
        }
        ret += etcTag( etc ) ;
        ret += ">" ;
        if( useString( _$script$query.get( name ) ) ) {
            ret += _$script$query.get( name ) ;
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + "</textarea>" ;
    }
    return "" ;
} ;

// テキストタグ.
textTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        var ret = "<input type=\"text\" name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
        }
        if( isNumeric( max ) ) {
            ret += "maxlength=\""+max+"\" " ;
        }
        if( useString( _$script$query.get( name ) ) ) {
            ret += "value=\""+ _$script$query.get( name ) + "\" " ;
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// パスワードタグ.
passwordTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        var ret = "<input type=\"password\" name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
        }
        if( isNumeric( max ) ) {
            ret += "maxlength=\""+max+"\" " ;
        }
        if( useString( _$script$query.get( name ) ) ) {
            ret += "value=\""+ _$script$query.get( name ) + "\" " ;
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ファイルタグ.
fileTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        var ret = "<input type=\"file\" name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
        }
        if( isNumeric( max ) ) {
            ret += "maxlength=\""+max+"\" " ;
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// チェックボックスタグ.
checkBoxTag = function(name,value,id,clazz,etc ) {
    if( useString( name ) == true && useString( value ) == true && __$type$script == "script" ) {
        var ret = "<input type=\"checkbox\" name=\""+name+"\" value=\""+value+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNull( _$script$query.get(name) ) == false ) {
            var lst = _$script$query.get(name) ;
            if( lst instanceof java.lang.String ) {
                if( lst == value ) {
                    ret += "checked " ;
                }
            }
            else if( lst instanceof java.util.List ) {
                var len = lst.size() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var s = lst.get( i ) ;
                    if( s == value ) {
                        ret += "checked " ;
                        break ;
                    }
                }
            }
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ラジオボタンタグ.
radioTag = function(name,value,id,clazz,etc ) {
    if( useString( name ) == true && useString( value ) == true && __$type$script == "script" ) {
        var ret = "<input type=\"radio\" name=\""+name+"\" value=\""+value+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNull( _$script$query.get(name) ) == false ) {
            var lst = _$script$query.get(name) ;
            if( lst instanceof java.lang.String ) {
                if( lst == value ) {
                    ret += "checked " ;
                }
            }
            else if( lst instanceof java.util.List ) {
                var len = lst.size() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var s = lst.get( i ) ;
                    if( s == value ) {
                        ret += "checked " ;
                        break ;
                    }
                }
            }
        }
        else {
            _$script$query.put(name,value) ;
            ret += "checked " ;
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// セレクトタグ.
selectTag = function(name,view,size,multiple,id,clazz,etc) {
    if( useString( name ) == true && ( valueof( view ) == "map" || valueof( view ) == "array" ) &&
        __$type$script == "script" ) {
        ret = "<select name=\""+name+"\" " ;
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
            if( size == 1 ) {
                size = null ;
            }
        }
        else {
            size = null ;
        }
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( size != null && isNull( multiple ) == false && multiple == true ) {
            ret += "multiple " ;
        }
        ret += etcTag( etc ) ;
        ret += ">\n" ;
        var t = valueof( view ) ;
        if( t == "map" ) {
            for( var k in view ) {
                ret += "    <option value=\""+k+"\" " ;
                if( isNull( _$script$query.get(name) ) == false ) {
                    var lst = _$script$query.get(name) ;
                    if( lst instanceof java.lang.String ) {
                        if( lst == k ) {
                            ret += "selected " ;
                        }
                    }
                    else if( lst instanceof java.util.List ) {
                        var len = lst.size() ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            var s = lst.get( i ) ;
                            if( s == k ) {
                                ret += "selected " ;
                                break ;
                            }
                        }
                    }
                }
                ret += ">"+view[k]+"</option>\n" ;
            }
        }
        else if( t == "array" ) {
            var len = view.length ;
            for( var i = 0 ; i < len ; i += 2 ) {
                var k = view[ i ] ;
                var v = view[ i + 1 ] ;
                ret += "    <option value=\""+k+"\" " ;
                if( isNull( _$script$query.get(name) ) == false ) {
                    var lst = _$script$query.get(name) ;
                    if( lst instanceof java.lang.String ) {
                        if( lst == k ) {
                            ret += "selected " ;
                        }
                    }
                    else if( lst instanceof java.util.List ) {
                        var len = lst.size() ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            var s = lst.get( i ) ;
                            if( s == k ) {
                                ret += "selected " ;
                                break ;
                            }
                        }
                    }
                }
                ret += ">"+v+"</option>\n" ;
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + "</select>" ;
    }
    return "" ;
}

////////////////////////////////////////////////////////////////////////////////
// Form内でのページバック機能.
////////////////////////////////////////////////////////////////////////////////

// オブジェクト.
PageBack = function(){} ;

// backPage用パラメータをセット.
PageBack.pushTag = function() {
    if( __$type$script == "script" ) {
        return hiddenTag("_pageBackMode","next","_pageBackModeId") ;
    }
    return "" ;
}

// backPage条件であるかチェック.
PageBack.isPageBack = function() {
    if( params[ '_pageBackMode' ] == "back" ) {
        return true ;
    }
    return false ;
}

// backPage条件の場合、指定URLにフォワード.
PageBack.forward = function(url) {
    if( useString( url ) == true ) {
        if( params[ '_pageBackMode' ] == "back" ) {
            forwardMHTML( url ) ;
        }
    }
}

// ページバックJavascriptを生成.
PageBack.createPageBackScript= function(formName) {
    return "javascript:document.getElementById('_pageBackModeId').value='back';document."+formName+".submit();" ;
}

// ページバックリンクタグ.
PageBack.linkTag = function(view,formName) {
    if( useString( view ) == true && __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        var ret = "<a href=\""+PageBack.createPageBackScript(formName)+"\">" ;
        ret += view ;
        return ret + "</a>" ;
    }
    return "" ;
}

// ページバック開始リンクタグ.
PageBack.startLinkTag = function(formName) {
    if( __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return "<a href=\""+PageBack.createPageBackScript(formName)+"\">" ;
    }
    return "" ;
}

// ページバックボタンタグ.
PageBack.button = function(value,formName) {
    if( useString( value ) == true && __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return button( value,"onclick=\""+PageBack.createPageBackScript(formName)+"\"" ) ;
    }
    return "" ;
}

// ページバックイメージボタンタグ.
PageBack.imgButton = function(name,src,formName,alt,border,width,height) {
    if( useString( name ) == true && useString( src ) == true &&
        __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        ret += " onclick=\"" + PageBack.createPageBackScript( formName ) + "\"" ;
        return ret + ">" ;
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// 2重押しを回避する機能.
////////////////////////////////////////////////////////////////////////////////

// オブジェクト.
DoubleSend = function() {}

DoubleSend.sessionKey = "_double_send" ;
DoubleSend.valueSize = 56 ;

// ２重押しパラメータを設定.
DoubleSend.pushTag = function() {
    if( isSession() ) {
        var value = "" + org.maachang.util.RandomUtil.randomString( DoubleSend.valueSize,true,true,true ) ;
        return hiddenTag( DoubleSend.sessionKey,value ) ;
    }
    return "" ;
}

// ２重押しされたかチェック.
DoubleSend.isDoubleSend = function() {
    if( isSession() ) {
        var value = getSession( DoubleSend.sessionKey ) ;
        if( useString( params[DoubleSend.sessionKey] ) == true ) {
            if( params[DoubleSend.sessionKey] == value ) {
                return true ;
            }
            putSession( DoubleSend.sessionKey,params[DoubleSend.sessionKey] ) ;
        }
    }
    return false ;
}

