package org.maachang.comet.httpd.engine.script.service.mail;

/**
 * 受信情報.
 * 
 * @version 2007/10/22.
 * @author masahito suzuki.
 * @since MaachangComet 1.00
 */
public class ReceiveMail {
    
    /**
     * 接続先.
     */
    private String host = null ;
    
    /**
     * ポート番号.
     */
    private int port = -1 ;
    
    /**
     * 接続ユーザ名.
     */
    private String user = null ;
    
    /**
     * 接続パスワード.
     */
    private String passwd = null ;
    
    /**
     * 受信タイムアウト値.
     */
    private long timeout = -1L ;
    
    /**
     * SSL接続.
     */
    private boolean ssl = false ;
    
    /**
     * 受信内容を削除.
     */
    private boolean delete = false ;
    
    /**
     * コンストラクタ.
     */
    public ReceiveMail() {
        
    }

    /**
     * host を取得.
     * <BR><BR>
     * @return host が返されます.
     */
    public String getHost() {
        return host;
    }

    /**
     * host を設定.
     * <BR><BR>
     * @param host host を設定します.
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * passwd を取得.
     * <BR><BR>
     * @return passwd が返されます.
     */
    public String getPasswd() {
        return passwd;
    }

    /**
     * passwd を設定.
     * <BR><BR>
     * @param passwd passwd を設定します.
     */
    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    /**
     * user を取得.
     * <BR><BR>
     * @return user が返されます.
     */
    public String getUser() {
        return user;
    }

    /**
     * user を設定.
     * <BR><BR>
     * @param user user を設定します.
     */
    public void setUser(String user) {
        this.user = user;
    }

    /**
     * ssl を取得.
     * <BR><BR>
     * @return ssl が返されます.
     */
    public boolean isSsl() {
        return ssl;
    }

    /**
     * ssl を設定.
     * <BR><BR>
     * @param ssl ssl を設定します.
     */
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    /**
     * timeout を取得.
     * <BR><BR>
     * @return timeout が返されます.
     */
    public long getTimeout() {
        return timeout;
    }

    /**
     * timeout を設定.
     * <BR><BR>
     * @param timeout timeout を設定します.
     */
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /**
     * delete を取得.
     * <BR><BR>
     * @return delete が返されます.
     */
    public boolean isDelete() {
        return delete;
    }

    /**
     * delete を設定.
     * <BR><BR>
     * @param delete delete を設定します.
     */
    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    /**
     * データチェック.
     * <BR><BR>
     * 設定された内容が正しいかチェックします.
     * <BR>
     * @return boolean [true]の場合、設定条件は正常です.
     */
    public boolean check() {
        if( host == null || ( host = host.trim() ).length() <= 0 ||
            user == null || ( user = user.trim() ).length() <= 0 ||
            passwd == null || ( passwd = passwd.trim() ).length() <= 0 ) {
            return false ;
        }
        return true ;
    }
    
    /**
     * オブジェクト内容を出力.
     */
    public String toString() {
        return new StringBuilder().
            append( "host:" ).append( host ).
            append( " port:" ).append( port ).
            append( " user:" ).append( user ).
            append( " passwd:" ).append( passwd ).
            append( " timeout:" ).append( timeout ).
            append( " ssl:" ).append( ssl ).
            append( " delete:" ).append( delete ).
            toString() ;
    }
}
