package org.maachang.comet.net ;

import java.io.IOException;
import java.io.OutputStream;

/**
 * HttpSocket用送信ストリーム.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpOutputStream extends OutputStream {
    
    private OutputStream outputStream = null ;
    
    private HttpOutputStream() {
    }
    
    public HttpOutputStream( OutputStream o ) {
        this.outputStream = o ;
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    public void destroy() {
        this.outputStream = null ;
    }
    
    public void close() throws IOException {
        if( isClosed() == false ) {
            this.flush() ;
            this.outputStream = null ;
        }
    }
    
    public void flush() throws IOException {
        if( isClosed() == false ) {
            this.outputStream.flush() ;
        }
    }
    
    public void write(int b) throws IOException {
        if( isClosed() == false ) {
            this.outputStream.write(b) ;
        }
    }
    
    public void write(byte b[]) throws IOException {
        if( isClosed() == false ) {
            this.outputStream.write(b) ;
        }
    }
    
    public void write(byte b[], int off, int len) throws IOException {
        if( isClosed() == false ) {
            this.outputStream.write(b,off,len) ;
        }
    }
    
    public OutputStream outputStream() {
        if( isClosed() == false ) {
            return this.outputStream ;
        }
        return null ;
    }
    
    public boolean isClosed() {
        if( this.outputStream == null ) {
            return true ;
        }
        return false ;
    }
}

