package org.maachang.dao.dbms;

import java.util.ArrayList;


/**
 * DBユーティリティ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class DbUtil {

    /**
     * Java用データ名をDB用データ名に変換.
     */
    public static final String convertJavaNameByDBName(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        if( name.indexOf( "_" ) != -1 ) {
            return name.toLowerCase() ;
        }
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        for (int i = 1; i < len; i++) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                buf.append("_");
            }
            buf.append(c);
        }
        String ret = buf.toString().toLowerCase();
        return ret;
    }

    /**
     * DB用データ名をJava用データ名に変換.
     */
    public static final String convertDBNameByJavaName(boolean table,
            String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        name = name.toLowerCase();
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        for (int i = 1; i < len; i++) {
            char c = name.charAt(i);
            if (c == '_') {
                if (i + 1 < len) {
                    char cp = name.charAt(i + 1);
                    if (cp >= 'a' && cp <= 'z') {
                        buf.append((char) ('A' + (cp - 'a')));
                        i++;
                        continue;
                    }
                }
                continue;
            }
            buf.append(c);
        }
        String ret = buf.toString();
        buf = null;
        if (table == true) {
            char c = ret.charAt(0);
            if (c >= 'a' && c <= 'z') {
                buf = new StringBuilder();
                buf.append((char) ('A' + (c - 'a'))).append(
                        ret.substring(1, ret.length()));
                ret = buf.toString();
            }
        }
        return ret;
    }
    
    /**
     * CSVを区切ります.
     * <BR>
     * @param cote [true]の場合ダブルコーテーションに統一します.
     *              [false]の場合シングルコーテーションに統一します.
     * @param line １行の内容を設定します.
     * @param cutCode 区切り文字を設定します.
     * @return ArrayList<String> 区切られた内容が返されます.
     * @exception Exception 例外.
     */
    public static final ArrayList<String> cutCsv( boolean cote,String line,String cutCode )
        throws Exception {
        if( line == null || line.length() <= 0 ) {
            return new ArrayList<String>() ;
        }
        if( cutCode == null || cutCode.length() <= 0 ) {
            cutCode = "," ;
        }
        ArrayList<String> tmp = new ArrayList<String>() ;
        int p = -1 ;
        int b = 0 ;
        int cutLen = cutCode.length() ;
        for( ;; ) {
            p = line.indexOf( cutCode,b ) ;
            if( p <= -1 ) {
                if( b == 0 ) {
                    tmp.add( line ) ;
                }
                else if( line.length() > b ) {
                    tmp.add( line.substring( b ) ) ;
                }
                break ;
            }
            char c = line.charAt( b ) ;
            if( c == '\'' || c == '\"' ) {
                int x = line.indexOf( c,b+1 ) ;
                if( x <= -1 ) {
                    tmp.add( new StringBuilder().append( line.substring( b ) ).append( c ).toString() ) ;
                    break ;
                }
                tmp.add( line.substring( b,x+1 ) ) ;
                b = x + 1 + cutLen ;
            }
            else {
                tmp.add( line.substring( b,p ) ) ;
                b = p + cutLen ;
            }
        }
        ArrayList<String> ret = new ArrayList<String>() ;
        int len = tmp.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            String x = tmp.get( i ) ;
            if( cote == true && x.startsWith( "\'" ) && x.endsWith( "\'") ) {
                ret.add( new StringBuilder().append( "\"" ).
                    append( x.substring( 1,x.length()-1 ) ).
                    append( "\"" ).toString() ) ;
            }
            else if( cote == false && x.startsWith( "\"" ) && x.endsWith( "\"") ) {
                ret.add( new StringBuilder().append( "\'" ).
                    append( x.substring( 1,x.length()-1 ) ).
                    append( "\'" ).toString() ) ;
            }
            else {
                ret.add( x ) ;
            }
        }
        tmp.clear() ;
        tmp = null ;
        return ret ;
    }
}
