// 拡張オブジェクト.
//

// bindingsに対するJSAdapter.
Bindings = function() {
    var core = bindings() ;
    return JSAdapter({
        __get__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            else if( core.containsKey( name ) ) {
                return core.get( name ) ;
            }
            return null ;
        },
        __has__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            return core.containsKey(name);
        },
        __put__ : function (name, value) {
            if( isNull( name ) || isNull( value ) ) {
                return ;
            }
            else if( value != null ) {
                core.put( name,value ) ;
            } ;
        },
        __delete__ : function (name) {
            if( isNull( name ) ) {
                return ;
            }
            core.remove( name ) ;
        },
        __getIds__ : function () {
            var ret = [] ;
            var o = org.maachang.comet.httpd.engine.script.cache.CacheScriptManager.getInstance().getWrapper().getAllKey() ;
            var len = o.length ;
            var cnt = 0 ;
            for( var i = 0 ; i < len ; i ++ ) {
                var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                ret[ cnt ] = one ;
                cnt ++ ;
            }
            return ret ;
        }
    }) ;
} ;

// カスタムオブジェクト.
CustomObject = function(name,parent) {
    if( useString( name ) == false ) {
        return null ;
    }
    var objectName = name ;
    var core = new java.util.HashMap() ;
    var parentName = "CustomObject" ;
    // 親オブジェクトが設定された場合は、親情報の内容をすべてコピー.
    if( isNull( parent ) == false &&
        className( parent ) == "JSAdapter" &&
        isNull(parent.core) == false &&
        isNull(parent.objectName) == false &&
        isNull(parent.parentName) == false ) {
        var src = parent.core ;
        var o = src.keySet().toArray() ;
        var len = o.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
            var val = src.get( one ) ;
            if( val == null ) {
                core.put( one,null ) ;
            }
            else {
                var t = valueof(val) ;
                if( t == "function" ) {
                    core.put( one,val ) ;
                }
                else if( t != "object" || className( val ) == "JSAdapter" ) {
                    if( className( val ) == "JSAdapter" &&
                        isNull( val.core ) == false &&
                        isNull( val.objectName ) == false &&
                        isNull( val.parentName ) == false ) {
                        core.put( one,val.newInstance() ) ;
                    }
                    else {
                        var buf = new StrBuf() ;
                        encodeJSON( val,buf ) ;
                        val = decodeJSON( buf.toString() ) ;
                        core.put( one,val ) ;
                        buf.clear() ;
                        buf = null ;
                    }
                }
            }
        }
        // オブジェクト名が同一名の場合、親オブジェクトは、
        // CustomObjectとする.
        parentName = src.get( "objectName" )() ;
        if( name == parentName ) {
            parentName = "CustomObject" ;
        }
        else {
            core.put( "parent",parent ) ;
        }
    }
    var currentJSAdapter = JSAdapter({
        __get__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            // core名が設定されている場合、取得できるようにする.
            else if( name == "core" ) {
                return core ;
            }
            else if( core.containsKey( name ) ) {
                return core.get( name ) ;
            }
            return null ;
        },
        __has__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            return core.containsKey(name);
        },
        __put__ : function (name, value) {
            if( isNull( name ) || isNull( value ) ) {
                return ;
            }
            // 上書き禁止条件の場合.
            if( name == "parent" ||
                name == "objectName" ||
                name == "parentName" ||
                name == "newInstance" ) {
                return ;
            }
            else if( value != null ) {
                core.put( name,value ) ;
            } ;
        },
        __delete__ : function (name) {
            if( isNull( name ) ) {
                return ;
            }
            // 上書き禁止条件の場合.
            if( name == "parent" ||
                name == "objectName" ||
                name == "parentName" ||
                name == "newInstance" ) {
                return ;
            }
            core.remove( name ) ;
        },
        __getIds__ : function () {
            var ret = [] ;
            var o = core.keySet().toArray() ;
            var len = o.length ;
            var cnt = 0 ;
            for( var i = 0 ; i < len ; i ++ ) {
                var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                if( startsWith( one,"private_" ) ) {
                    continue ;
                }
                ret[ cnt ] = one ;
                cnt ++ ;
            }
            return ret ;
        }
    }) ;
    core.put( "objectName",
        function() {
            return objectName ;
        } ) ;
    core.put( "parentName",
        function() {
            return parentName ;
        } ) ;
    core.put( "newInstance",
        function() {
            return CustomObject( objectName,currentJSAdapter ) ;
        } ) ;
    if( core.containsKey( "parent" ) == false ) {
        core.put( "parent",null ) ;
    }
    return currentJSAdapter ;
} ;

