/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.BaseConfig;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.comet.down.SendShutdown;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptByDirectorys;
import org.maachang.conf.ConvIniParam;
import org.maachang.util.FileUtil;

public class Shutdown {
    private static final Log LOG = LogFactory.getLog(CacheScriptByDirectorys.class);
    private static final int TIMEOUT = 5000;
    private static final int RETRY = 12;

    public static final void main(String[] args) throws Exception {
        new Shutdown().execution(args);
    }

    private void execution(String[] args) throws Exception {
        int port = Shutdown.getPort();
        if (args != null || args.length >= 1) {
            int argsPort = -1;
            try {
                argsPort = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                argsPort = -1;
            }
            if (argsPort > 0 && argsPort <= 65535) {
                port = argsPort;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("# \u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u3092\u5b9f\u65bd:" + port));
        }
        int exitCode = 0;
        boolean retry = false;
        try {
            int i = 0;
            while (i < 12) {
                if (new SendShutdown().send(port, 5000)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"# \u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u7d42\u4e86");
                    }
                    retry = true;
                    break;
                }
                ++i;
            }
            if (!retry) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"# \u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u7d42\u4e86\u901a\u77e5\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                exitCode = -1;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"# \u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u3067\u30a8\u30e9\u30fc", (Throwable)e);
            }
            exitCode = -1;
        }
        System.exit(exitCode);
    }

    private static final int getPort() throws Exception {
        String path = StartupConfig.getPath(".");
        String confPath = String.valueOf(path) + "conf/";
        confPath = String.valueOf(FileUtil.getFullPath((String)confPath)) + FileUtil.FILE_SPACE;
        BaseConfig conf = StartupConfig.getBaseConfig(confPath);
        int len = conf.size();
        IniFile config = new IniFile();
        int i = 0;
        while (i < len) {
            String name = conf.getConfig(i);
            if (name != null && (name = name.trim()).length() > 0) {
                StartupConfig.readConfig(config, confPath, name);
            }
            ++i;
        }
        return ConvIniParam.getInt((String)config.get("server", "shutdown-port", 0));
    }
}

