/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.maachang.util.StringUtil;

public class HttpdTimestamp {
    private static final String WKDAY_SUNDAY = "Sun";
    private static final String WKDAY_MONDAY = "Mon";
    private static final String WKDAY_TUESDAY = "Tue";
    private static final String WKDAY_WEDNESDAY = "Wed";
    private static final String WKDAY_THURSDAY = "Thu";
    private static final String WKDAY_FRIDAY = "Fri";
    private static final String WKDAY_SATURDAY = "Sat";
    private static final String[] MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] CK_MONTH = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final String GREENWICH = "GMT";
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("Europe/London");

    public static final String getNowTimestamp() {
        return HttpdTimestamp.getTimestamp(System.currentTimeMillis());
    }

    public static final String getNowTimestamp(boolean mode) {
        return HttpdTimestamp.getTimestamp(mode, System.currentTimeMillis());
    }

    public static final String getTimestamp(long time) {
        return HttpdTimestamp.getTimestamp(false, time);
    }

    public static final String getTimestamp(boolean mode, long time) {
        StringBuffer buf = null;
        GregorianCalendar cal = null;
        String tmp = null;
        String ret = null;
        try {
            try {
                cal = new GregorianCalendar(GMT_TIMEZONE);
                cal.setTime(new Date(time));
                buf = new StringBuffer();
                buf.append(HttpdTimestamp.getWeekCode(cal));
                buf.append(", ");
                if (mode) {
                    tmp = String.valueOf(cal.get(5));
                    buf.append("00".substring(tmp.length()));
                    buf.append(tmp);
                    buf.append("-");
                    buf.append(MONTH[cal.get(2)]);
                    buf.append("-");
                } else {
                    tmp = String.valueOf(cal.get(5));
                    buf.append("00".substring(tmp.length()));
                    buf.append(tmp);
                    buf.append(" ");
                    buf.append(MONTH[cal.get(2)]);
                    buf.append(" ");
                }
                tmp = String.valueOf(cal.get(1));
                buf.append("0000".substring(tmp.length()));
                buf.append(tmp);
                buf.append(" ");
                tmp = String.valueOf(cal.get(11));
                buf.append("00".substring(tmp.length()));
                buf.append(tmp);
                buf.append(":");
                tmp = String.valueOf(cal.get(12));
                buf.append("00".substring(tmp.length()));
                buf.append(tmp);
                buf.append(":");
                tmp = String.valueOf(cal.get(13));
                buf.append("00".substring(tmp.length()));
                buf.append(tmp);
                buf.append(" ");
                buf.append(GREENWICH);
                ret = buf.toString();
            }
            catch (Exception e) {
                ret = null;
            }
        }
        finally {
            buf = null;
            cal = null;
            tmp = null;
        }
        return ret;
    }

    public static final long convertTimestamp(String timestamp) {
        long ret;
        block7: {
            ArrayList lst = null;
            GregorianCalendar cal = null;
            try {
                try {
                    cal = new GregorianCalendar(GMT_TIMEZONE);
                    cal.clear();
                    lst = StringUtil.cutString((String)timestamp, (String)" \t,:-");
                    int len = lst.size();
                    if (len == 8) {
                        cal.set(5, Integer.parseInt((String)lst.get(1)));
                        HttpdTimestamp.setMonth(cal, (String)lst.get(2));
                        cal.set(1, Integer.parseInt((String)lst.get(3)));
                        cal.set(11, Integer.parseInt((String)lst.get(4)));
                        cal.set(12, Integer.parseInt((String)lst.get(5)));
                        cal.set(13, Integer.parseInt((String)lst.get(6)));
                        ret = cal.getTime().getTime();
                        break block7;
                    }
                    ret = Long.MIN_VALUE;
                }
                catch (Exception e) {
                    ret = Long.MIN_VALUE;
                }
            }
            finally {
                if (lst != null) {
                    lst.clear();
                }
                lst = null;
                cal = null;
            }
        }
        return ret;
    }

    public static final long createTime(long time) {
        return time / 1000L * 1000L;
    }

    private HttpdTimestamp() {
    }

    private static final String getWeekCode(Calendar date) {
        String ret = null;
        switch (date.get(7)) {
            case 1: {
                ret = WKDAY_SUNDAY;
                break;
            }
            case 2: {
                ret = WKDAY_MONDAY;
                break;
            }
            case 3: {
                ret = WKDAY_TUESDAY;
                break;
            }
            case 4: {
                ret = WKDAY_WEDNESDAY;
                break;
            }
            case 5: {
                ret = WKDAY_THURSDAY;
                break;
            }
            case 6: {
                ret = WKDAY_FRIDAY;
                break;
            }
            case 7: {
                ret = WKDAY_SATURDAY;
                break;
            }
            default: {
                ret = "?";
            }
        }
        return ret;
    }

    private static final void setMonth(Calendar out, String code) {
        int len = CK_MONTH.length;
        code = code.toLowerCase();
        int i = 0;
        while (i < len) {
            if (code.equals(CK_MONTH[i])) {
                out.set(2, i);
                break;
            }
            ++i;
        }
    }
}

