/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.WebAppScriptFactory;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.manager.GlobalManager;
import org.maachang.util.StringUtil;

public class BaseScriptException
extends Exception {
    private static final long serialVersionUID = -8407798868124851487L;
    private static final Log LOG = LogFactory.getLog(BaseScriptException.class);
    private static final String START_LINE = "(";
    private static final String END_LINE = ")";
    private static final int OUTPUT_LINE_SIZE = 11;
    private ScriptException scriptException = null;
    private String errorScriptInfo = null;

    private BaseScriptException() {
    }

    public BaseScriptException(ScriptException scriptException) {
        if (scriptException == null) {
            return;
        }
        this.scriptException = scriptException;
        this.errorScriptInfo = this.convertErrorInfo(scriptException.getMessage());
    }

    public ScriptException getScriptException() {
        return this.scriptException;
    }

    public String getErrorScriptInfo() {
        return this.errorScriptInfo;
    }

    private String convertErrorInfo(String msg) {
        String name = null;
        SrcScript src = null;
        String[] scriptName = new String[]{""};
        int line = this.getErrorLine(scriptName, msg);
        if (line == -1) {
            return "";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... errorScript:" + scriptName[0]));
        }
        WebAppScriptFactory factory = BaseScriptException.getFactory();
        try {
            Script script = factory.getApplication(scriptName[0]);
            if (script != null) {
                src = script.getSrcScript();
                name = script.getScriptName();
            } else {
                src = null;
                name = null;
            }
        }
        catch (Exception e) {
            src = null;
            name = null;
        }
        if (src == null && CacheScriptManager.getInstance().isCache(scriptName[0])) {
            src = CacheScriptManager.getInstance().getSrcScript(scriptName[0]);
            name = scriptName[0];
        }
        if (src == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<code>src&nbsp;&nbsp;:</code>&nbsp;");
        buf.append(name);
        buf.append("<BR>");
        buf.append("<table width=100% cellpadding=0 cellspacing=0><tr><td bgcolor=#0000ff><img alt=\"\" width=1 height=2></td></tr></table>");
        int start = line - 5;
        int i = 0;
        while (i < 11) {
            String sc = src.get(i + start);
            if (sc != null) {
                if (sc.length() > 0) {
                    sc = StringUtil.changeString((String)sc, (String)" ", (String)"&nbsp;");
                }
                if (i + start == line) {
                    buf.append("<font color=#cc0000>");
                }
                buf.append(i + start);
                buf.append("&nbsp;:&nbsp;");
                buf.append(sc);
                if (i + start == line) {
                    buf.append("</font>");
                }
                buf.append("<BR>");
            }
            ++i;
        }
        buf.append("<table width=100% cellpadding=0 cellspacing=0><tr><td bgcolor=#0000ff><img alt=\"\" width=1 height=2></td></tr></table>");
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    private int getErrorLine(String[] script, String msg) {
        p = msg.indexOf("(");
        if (p == -1) {
            return -1;
        }
        do lbl-1000:
        // 3 sources

        {
            block6: {
                if (!BaseScriptException.isErrorInfo(msg, p)) continue;
                p1 = msg.indexOf("#", p);
                e = msg.indexOf(")", p);
                if (p1 == -1 || e == -1) {
                    return -1;
                }
                str = msg.substring(p1 + "#".length(), e);
                ret = -1;
                try {
                    ret = Integer.parseInt(str);
                }
                catch (Exception ee) {
                    ret = -1;
                }
                if (ret != -1) break block6;
                if ((p = msg.indexOf("(", p + 1)) != -1) ** GOTO lbl-1000
                return -1;
            }
            script[0] = msg.substring(p + "(".length(), p1);
            if (script[0] != null) {
                script[0] = script[0].trim();
            }
            return ret;
        } while ((p = msg.indexOf("(", p + 1)) != -1);
        return -1;
    }

    private static final boolean isErrorInfo(String msg, int start) {
        int p = msg.indexOf(END_LINE, start);
        if (p == -1) {
            return false;
        }
        int b = msg.lastIndexOf("#", p);
        return b != -1 && b <= p;
    }

    private static final WebAppScriptFactory getFactory() {
        return (WebAppScriptFactory)GlobalManager.getValue((String)"WEBAPP_FACTORY");
    }
}

