/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.util.ArrayList;
import org.maachang.util.StringUtil;

public class ConvertScript {
    public static final String convertMethod(String string) {
        return ConvertScript.convertMethod(true, 0, string);
    }

    public static final String convert(String script) throws Exception {
        return ConvertScript.convert(true, 0, script);
    }

    private static final String convert(boolean mode, int scope, String script) throws Exception {
        if (script == null || script.length() <= 0 || script.indexOf("@") == -1) {
            return script;
        }
        int len = script.length();
        StringBuilder buf = new StringBuilder((int)((float)len * 1.25f));
        int n = -1;
        char b = '\u0000';
        int st = -1;
        int parenthesesCnt = 0;
        boolean cm1 = false;
        boolean cm2 = false;
        boolean scopeFlag = false;
        int i = 0;
        while (i < len) {
            char c = script.charAt(i);
            if (cm1 || cm2) {
                buf.append(c);
                if (cm1 && (c == '\r' || c == '\n')) {
                    cm1 = false;
                } else if (cm2 && c == '*' && len > i + 1 && script.charAt(i + 1) == '/') {
                    cm2 = false;
                }
                b = c;
            } else {
                char c2;
                if (c2 != '\uffffffff') {
                    if (st == -1) {
                        buf.append(c);
                    }
                    if (c == c2 && (i != 0 && b != '\\' || i == 0)) {
                        c2 = '\uffffffff';
                    }
                } else if ((c == '\'' || c == '\"') && (i != 0 && b != '\\' || i == 0)) {
                    if (st == -1) {
                        buf.append(c);
                    }
                    c2 = c;
                } else if (st == -1 && c == '/') {
                    buf.append(c);
                    if (len > i + 1 && script.charAt(i + 1) == '/') {
                        cm1 = true;
                    } else if (len > i + 1 && script.charAt(i + 1) == '*') {
                        cm2 = true;
                    }
                } else if (!(scopeFlag || scope <= 0 || c != '(' && c != ')')) {
                    parenthesesCnt = c == '(' ? ++parenthesesCnt : --parenthesesCnt;
                    if (parenthesesCnt <= 0 && st != -1) {
                        scopeFlag = true;
                        --i;
                    }
                    if (st == -1) {
                        buf.append(c);
                    }
                } else if (c == '@' && st == -1 && ConvertScript.check(script, i)) {
                    st = i;
                    parenthesesCnt = 0;
                } else if (st != -1 && (c == ';' || c == '\r' || c == '\n' || i + 1 == len || scopeFlag || c == '%' && len > i + 1 && script.charAt(i + 1) == '>')) {
                    String one = null;
                    one = !scopeFlag && i + 1 == len ? script.substring(st, len) : script.substring(st, i);
                    if (c == ';' || scopeFlag || c == '%' && len > i + 1 && script.charAt(i + 1) == '>') {
                        if ((one = ConvertScript.convertMethod(false, scope, one)).indexOf("@") != -1) {
                            one = ConvertScript.convert(false, scope + 1, one);
                        }
                        if (scopeFlag && i + 1 != len) {
                            buf.append(one);
                            if (parenthesesCnt <= -1) {
                                buf.append(c);
                                parenthesesCnt = 0;
                            }
                        } else {
                            buf.append(one).append(c);
                        }
                    } else {
                        if ((one = ConvertScript.convertMethod(mode, scope, one)).indexOf("@") != -1) {
                            one = ConvertScript.convert(mode, scope + 1, one);
                        }
                        buf.append(one);
                    }
                    if (c == '\r' || c == '\n') {
                        buf.append(c);
                    }
                    st = -1;
                    scopeFlag = false;
                } else if (st == -1) {
                    buf.append(c);
                }
                b = c;
            }
            ++i;
        }
        if (st != -1) {
            String one = script.substring(st, len - 1);
            if ((one = ConvertScript.convertMethod(mode, scope, one)).indexOf("@") != -1) {
                one = ConvertScript.convert(mode, scope + 1, one);
            }
            buf.append(one);
        }
        return buf.toString();
    }

    private static final String convertMethod(boolean mode, int scope, String string) {
        if (string.startsWith("@")) {
            ArrayList lst;
            if (!ConvertScript.check(string, 0)) {
                return string;
            }
            string = string.substring("@".length(), string.length());
            string = ConvertScript.pushSpace(string);
            int scnt = StringUtil.getCount((String)string, (char)'(');
            int ecnt = StringUtil.getCount((String)string, (char)')');
            if (scnt != 0 || ecnt != 0) {
                string = ConvertScript.cutParentheses(true, scope, string);
                string = ConvertScript.cutParentheses(false, scope, string);
            }
            if ((lst = StringUtil.cutString((boolean)true, (boolean)true, (String)string, (String)" \u3000\t;")) != null && lst.size() > 0) {
                int len = lst.size();
                StringBuilder buf = new StringBuilder();
                buf.append((String)lst.get(0));
                buf.append(" (");
                int i = 1;
                while (i < len) {
                    if (i != 1) {
                        buf.append(" ");
                    }
                    buf.append((String)lst.get(i));
                    ++i;
                }
                buf.append(" )");
                if (mode) {
                    buf.append(";");
                }
                string = buf.toString();
            }
        }
        return string;
    }

    private static final String cutParentheses(boolean mode, int scope, String string) {
        if (string.indexOf("(") == -1 && string.indexOf(")") == -1) {
            return string;
        }
        ArrayList lst = null;
        lst = mode ? StringUtil.parseString((String)string, (String)"(") : StringUtil.parseString((String)string, (String)")");
        if (lst.size() <= 0) {
            return string;
        }
        int len = lst.size();
        if (len == 1) {
            if (mode && string.endsWith("(")) {
                string.substring(0, string.length() - 1);
            }
            if (!mode && string.startsWith(")")) {
                string.substring(1, string.length());
            }
            return string;
        }
        if (mode) {
            int i;
            boolean notFirst = false;
            String start = (String)lst.get(0);
            int startLen = start.length();
            int i2 = 0;
            while (i2 < startLen) {
                char c = start.charAt(i2);
                if (c == ' ' || c == '\u3000' || c == '\r' || c == '\n' || c == '\t') {
                    notFirst = true;
                    break;
                }
                ++i2;
            }
            if (notFirst) {
                StringBuilder buf = new StringBuilder();
                if (len > 1) {
                    i = 0;
                    while (i < len) {
                        if (i != 0) {
                            buf.append("(");
                        }
                        buf.append((String)lst.get(i));
                        ++i;
                    }
                } else if (len == 1) {
                    buf.append((String)lst.get(0));
                }
                string = buf.toString().trim();
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append((String)lst.get(0)).append(" ");
                if (len > 2) {
                    i = 1;
                    while (i < len) {
                        if (i != 1) {
                            buf.append("(");
                        }
                        buf.append((String)lst.get(i));
                        ++i;
                    }
                } else if (len == 2) {
                    buf.append((String)lst.get(1));
                }
                string = buf.toString().trim();
            }
        } else {
            if (((String)lst.get(len - 1)).length() <= 0 || ";".equals(lst.get(len - 1))) {
                --len;
            }
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                buf.append((String)lst.get(i));
                buf.append(")");
                ++i;
            }
            string = buf.toString().trim();
            if (scope == 0 && string.endsWith(")")) {
                string = String.valueOf(string.substring(0, string.length() - 1)) + " ;";
            }
        }
        return string;
    }

    private static final boolean check(String string, int no) {
        int len = string.length();
        if (len <= no + 1) {
            return false;
        }
        char c = string.charAt(no + 1);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static final String pushSpace(String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return "";
        }
        int n = -1;
        int b = 0;
        int len = string.length();
        StringBuilder buf = new StringBuilder((int)((float)string.length() * 1.25f));
        int i = 0;
        while (i < len) {
            char c;
            char c2 = string.charAt(i);
            if (c != '\uffffffff') {
                if (c2 == c && (i != 0 && b != 92 || i == 0)) {
                    c = '\uffffffff';
                }
                buf.append(c2);
            } else if ((c2 == '\'' || c2 == '\"') && (i != 0 && b != 92 || i == 0)) {
                c = c2;
                buf.append(c2);
            } else if (c2 == '(' || c2 == ')') {
                if (b != 32) {
                    buf.append(" ").append(c2);
                } else {
                    buf.append(c2);
                }
            } else {
                buf.append(c2);
            }
            b = c2;
            ++i;
        }
        return buf.toString();
    }
}

