/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.util.ArrayList;
import java.util.List;
import org.maachang.comet.httpd.HttpSocket;

public class HttpSocketManager {
    private List<HttpSocket> manager = new ArrayList<HttpSocket>();

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.manager != null) {
            int len = this.manager.size();
            int i = 0;
            while (i < len) {
                HttpSocket v = this.manager.get(i);
                if (v != null) {
                    v.destroy();
                }
                ++i;
            }
            this.manager = null;
        }
    }

    public synchronized void append(HttpSocket v) {
        if (this.isClosed() || v == null || v.isClosed()) {
            return;
        }
        this.manager.add(v);
    }

    public synchronized HttpSocket get(int no) {
        if (this.isClosed() || no < 0 || no >= this.manager.size()) {
            return null;
        }
        return this.manager.get(no);
    }

    public synchronized void remove(int no) {
        if (this.isClosed() || no < 0 || no >= this.manager.size()) {
            return;
        }
        this.manager.remove(no);
    }

    public synchronized int size() {
        if (this.isClosed()) {
            return 0;
        }
        return this.manager.size();
    }

    public synchronized boolean isClosed() {
        return this.manager == null;
    }
}

