/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import org.maachang.comet.conf.MimeConfig;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.HttpdCookie;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.comet.net.ChunkedOutputStream;
import org.maachang.comet.net.NetWriteHttpd;
import org.maachang.conf.ConvIniParam;
import org.maachang.manager.GlobalManager;

public class HttpdBaseResponseImpl
implements HttpdResponse {
    protected int state = 200;
    protected String version = "1.1";
    private HttpConnectionInfo connectionInfo = null;
    protected HttpdHeaders header = null;
    protected boolean cacheMode = false;
    protected boolean gzipFlag = true;
    protected String gzipName = null;
    private String requestURL = null;
    private NetWriteHttpd output = null;
    private OutputStream outputStream = null;
    private PrintWriter printWriter = null;
    private boolean closeFlag = true;
    private boolean requestKeepAlive = false;
    private HttpdRequest request = null;
    private boolean localhostFlag = false;

    private HttpdBaseResponseImpl() {
    }

    public HttpdBaseResponseImpl(HttpdRequest request, String url, long timeout, int count) throws Exception {
        this(request, url, 200, timeout, count);
    }

    public HttpdBaseResponseImpl(HttpdRequest request, String url, int state, long timeout, int count) throws Exception {
        if (request == null || request.getConnectionInfo() == null || !request.getConnectionInfo().isUse()) {
            throw new IOException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.requestURL = url;
        this.state = state;
        this.connectionInfo = request.getConnectionInfo();
        this.header = new HttpdHeaders();
        if (request.getHeader().getHeader("Accept-Encoding") != null) {
            HttpdHeaders requestHeader = request.getHeader();
            int len = requestHeader.size("Accept-Encoding");
            boolean chkFlag = false;
            if (request.isGzip()) {
                int i = 0;
                while (i < len) {
                    String encode = requestHeader.getHeader("Accept-Encoding", i);
                    if (encode != null && encode.indexOf("gzip") != -1) {
                        if ((encode = encode.trim()).length() <= 0) {
                            this.gzipName = null;
                            chkFlag = false;
                            break;
                        }
                        this.gzipName = encode;
                        chkFlag = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!chkFlag) {
                this.gzipName = null;
            } else {
                String type;
                MimeConfig mimeType = (MimeConfig)GlobalManager.getValue((String)"MIME_TYPE");
                int p = url.lastIndexOf(".");
                String plus = null;
                if (p != -1) {
                    plus = url.substring(p + 1);
                }
                if (plus == null || (plus = plus.trim()).length() <= 0) {
                    plus = "";
                }
                if (!ConvIniParam.getBoolean((String)(type = mimeType.get("gzip." + plus)))) {
                    this.gzipName = null;
                }
            }
        } else {
            this.gzipName = null;
        }
        this.version = request.getVersion();
        if ("1.1".equals(this.version) && request.getHeader().isKeepAlive()) {
            if (timeout > 0L && count > 0) {
                this.request = request;
                this.requestKeepAlive = true;
            } else {
                this.request = null;
                this.requestKeepAlive = false;
            }
        } else {
            this.requestKeepAlive = false;
        }
        this.localhostFlag = "127.0.0.1".equals(this.connectionInfo.getSocket().socket().getInetAddress().getHostAddress());
        this.setHttpClose(true);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.flush();
        if (!this.destroyByNoOutputStream()) {
            if (this.printWriter != null) {
                try {
                    this.printWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.header = null;
        this.cacheMode = false;
        this.gzipFlag = true;
        this.gzipName = null;
        this.connectionInfo = null;
        this.requestURL = null;
        this.output = null;
        this.outputStream = null;
        this.printWriter = null;
        this.closeFlag = true;
        this.requestKeepAlive = false;
        this.request = null;
    }

    public void cancel() {
        if (this.connectionInfo != null) {
            this.connectionInfo.cancel();
        }
        this.connectionInfo = null;
        this.header = null;
        this.cacheMode = false;
        this.gzipFlag = true;
        this.gzipName = null;
        this.requestURL = null;
        this.output = null;
        this.outputStream = null;
        this.printWriter = null;
        this.closeFlag = true;
        this.requestKeepAlive = false;
        this.request = null;
    }

    public void flush() {
        if (this.printWriter != null) {
            try {
                this.printWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.outputStream instanceof GZIPOutputStream) {
                try {
                    ((GZIPOutputStream)this.outputStream).finish();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setGzip(boolean flag) {
        this.gzipFlag = flag;
    }

    public boolean getGzip() {
        if (this.gzipName == null) {
            return false;
        }
        return this.gzipFlag;
    }

    public void setHttpCache(boolean cache) {
        this.cacheMode = cache;
    }

    public boolean getHttpCache() {
        return this.cacheMode;
    }

    public void setCookieSession(HttpdRequest request) throws Exception {
        if (request == null) {
            return;
        }
        HttpdSession session = request.getSession();
        if (session != null) {
            int len = 0;
            len = this.header.size("Set-Cookie");
            if (len > 0) {
                int i = len - 1;
                while (i >= 0) {
                    String value = this.header.getHeader("Set-Cookie", i);
                    if (value != null && value.indexOf("maachang-session=") != -1) {
                        this.header.removeHeader("Set-Cookie", i);
                    }
                    --i;
                }
            }
            HttpdSessionManager sessionManager = (HttpdSessionManager)GlobalManager.getValue((String)"SESSION_MANAGER");
            long time = System.currentTimeMillis() + sessionManager.getDeleteTime();
            String value = HttpdCookie.createCookie("maachang-session", session.getSessionId(), "/", time);
            this.header.addHeader("Set-Cookie", value);
        }
    }

    public HttpdHeaders getHeader() {
        return this.header;
    }

    public void setDestroyByClose(boolean mode) {
        try {
            this.connectionInfo.setCloseFlag(mode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRequestKeepAlive() {
        return this.requestKeepAlive;
    }

    public void setHttpClose(boolean closeFlag) {
        this.closeFlag = !this.requestKeepAlive || this.localhostFlag ? true : closeFlag;
    }

    public boolean getHttpClose() {
        return this.closeFlag;
    }

    public OutputStream getOutput() throws Exception {
        if (this.printWriter != null) {
            return null;
        }
        if (this.outputStream == null) {
            boolean keepFlag = !this.closeFlag;
            boolean chkFlag = false;
            if (this.output == null) {
                this.output = new NetWriteHttpd(this.connectionInfo, this.requestURL, this.state, this.version, keepFlag);
                if (this.closeFlag) {
                    this.output.closeOn();
                    this.setDestroyByClose(true);
                } else if (this.requestKeepAlive) {
                    this.output.closeOff();
                    this.header.addHeader("Keep-Alive", "timeout=" + this.request.getKeepAliveTimeout() / 1000L);
                    this.header.addHeader("Keep-Alive", "max=" + this.request.getKeepAliveCount());
                    this.setDestroyByClose(false);
                } else {
                    this.output.closeOn();
                    this.setDestroyByClose(true);
                }
                this.output.baseHeader();
                if (this.header != null) {
                    this.output.pushHeaders(this.header);
                }
                if (this.cacheMode) {
                    this.output.cacheOff();
                }
                if ("1.1".equals(this.version) && this.getGzip()) {
                    this.output.pushHeader("Content-Encoding", this.gzipName);
                    this.output.setGzip(true);
                }
            }
            OutputStream os = this.output.getOutputStream();
            chkFlag = this.output.isChunked();
            this.outputStream = this.getGzip() ? new GZIPOutputStream(new ChunkedOutputStream(os)) : (chkFlag ? new ChunkedOutputStream(os) : new BufferedOutputStream(os));
        }
        return this.outputStream;
    }

    public PrintWriter getPrint() throws Exception {
        if (this.printWriter == null) {
            PrintWriter p;
            OutputStream os = this.getOutput();
            this.printWriter = p = new PrintWriter(new OutputStreamWriter(os, "UTF8"));
        }
        return this.printWriter;
    }

    public boolean isOutputStream() {
        return this.output != null;
    }

    private boolean destroyByNoOutputStream() {
        if (!this.isOutputStream()) {
            try {
                boolean keepFlag = !this.closeFlag;
                this.output = new NetWriteHttpd(this.connectionInfo, this.requestURL, this.state, this.version, keepFlag);
                if (this.closeFlag) {
                    this.output.closeOn();
                    this.setDestroyByClose(true);
                } else if (this.requestKeepAlive) {
                    this.output.closeOff();
                    this.header.addHeader("Keep-Alive", "timeout=" + this.request.getKeepAliveTimeout() / 1000L);
                    this.header.addHeader("Keep-Alive", "max=" + this.request.getKeepAliveCount());
                    this.setDestroyByClose(false);
                } else {
                    this.output.closeOn();
                    this.setDestroyByClose(true);
                }
                this.header.setHeader("Content-Length", "0");
                this.output.baseHeader();
                if (this.header != null) {
                    this.output.pushHeaders(this.header);
                }
                if (this.cacheMode) {
                    this.output.cacheOff();
                }
                OutputStream out = this.output.getOutputStream();
                out.flush();
                out.close();
                this.output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

