package org.maachang.comet.conf ;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import org.maachang.comet.MaachangDef;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

/**
 * mail.conf用読み込みファイル.
 *
 * @version 2007/11/20
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class MailConfig {
    
    /**
     * 読み込みファイル名.
     */
    private static final String READ_FILE = MaachangDef.DIRECTORY_CONFIG+"mail.conf" ;
    
    /**
     * キャラクタセット.
     */
    private static final String CHARSET = "UTF8" ;
    
    /**
     * 読み込み対象データ.
     */
    private Config iniParams = null ;
    
    /**
     * 対象ファイル.
     */
    private String fileName = null ;
    
    /**
     * 最終更新日.
     */
    private long lastUpdate = -1L ;
    
    /**
     * コンストラクタ.
     */
    public MailConfig() {
        
    }
    
    /**
     * オープン.
     * <BR><BR>
     * オープンします.
     * <BR>
     * @exception Exception 例外.
     */
    public synchronized void open() throws Exception {
        this.open( READ_FILE ) ;
    }
    
    /**
     * オープン.
     * <BR><BR>
     * オープンします.
     * <BR>
     * @param name 対象のファイル名を設定します.
     * @exception Exception 例外.
     */
    public synchronized void open( String name ) throws Exception {
        this.fileName = FileUtil.getFullPath( name ) ;
        try {
            this.reload() ;
        } catch( Exception e ) {
            this.close() ;
            throw e ;
        } finally {
        }
    }
    
    /**
     * クローズ.
     * <BR><BR>
     * クローズ処理.
     */
    public synchronized void close() {
        iniParams = null ;
        fileName = null ;
        lastUpdate = -1L ;
    }
    
    /**
     * SMTPセクションの指定名の条件を取得.
     * <BR><BR>
     * SMTPセクションの指定名の条件を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return String 対象の条件が返されます.
     */
    public synchronized String getSmtp( String name ) {
        try {
            long tm = FileUtil.getLastTime( fileName ) ;
            if( lastUpdate != tm ) {
                this.reload() ;
            }
        } catch( Exception e ) {
        }
        return iniParams.get( "smtp",name,0 ) ;
    }
    
    /**
     * POP3セクションの指定名の条件を取得.
     * <BR><BR>
     * POP3セクションの指定名の条件を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return String 対象の条件が返されます.
     */
    public synchronized String getPop3( String name ) {
        try {
            long tm = FileUtil.getLastTime( fileName ) ;
            if( lastUpdate != tm ) {
                this.reload() ;
            }
        } catch( Exception e ) {
        }
        return iniParams.get( "pop3",name,0 ) ;
    }
    
    /**
     * 再読み込み.
     */
    private final void reload()
        throws Exception {
        BufferedReader buf = null ;
        if( FileUtil.isFileExists( fileName ) == true ) {
            try {
                buf = new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream( fileName ),CHARSET ) ) ;
                Config iniParams = new Config() ;
                ReadIni.analisys( iniParams,buf ) ;
                buf.close() ;
                buf = null ;
                long last = FileUtil.getLastTime( fileName ) ;
                // 読み込みデータを設定.
                this.iniParams = iniParams ;
                this.lastUpdate = last ;
            } catch( Exception e ) {
                throw e ;
            } finally {
                if( buf != null ) {
                    try {
                        buf.close() ;
                    } catch( Exception e ) {
                    }
                }
            }
        }
    }
    
    /**
     * 文字列に変換.
     */
    public String toString() {
        if( iniParams != null ) {
            return iniParams.toString() ;
        }
        return "null" ;
    }
}

