package org.maachang.comet.httpd ;

/**
 * HTTPD-Error定義.
 *
 * @version 2007/08/19
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpdErrorDef {
    /**
     * HTTP1.0 エラーコード :OK 正常送信.
     */
    public static final int HTTP10_200 = 200 ;
    
    /**
     * HTTP1.0 エラーコード :Created 別の場所からデータを送る時に送信される.
     */
    public static final int HTTP10_201 = 201 ;
    
    /**
     * HTTP1.0 エラーコード :Accepted CGIのように別な場所でデータを作成する時など.
     */
    public static final int HTTP10_202 = 202 ;
    
    /**
     * HTTP1.0 エラーコード :No Content 空のページへアクセスしようとした時.
     */
    public static final int HTTP10_204 = 204 ;
    
    /**
     * HTTP1.0 エラーコード :Moved Permanently サイトが別の場所へ移動した時.
     */
    public static final int HTTP10_301 = 301 ;
    
    /**
     * HTTP1.0 エラーコード :Moved Temporarily サイトが一時的に移動した時.
     */
    public static final int HTTP10_302 = 302 ;
    
    /**
     * HTTP1.0 エラーコード :Not Modified 一定時間内に中身が変わったらダウンロードする設定の時.
     */
    public static final int HTTP10_304 = 304 ;
    
    /**
     * HTTP1.0 エラーコード :Bad Request 打ち込んだURLが変に間違った時.
     */
    public static final int HTTP10_400 = 400 ;
    
    /**
     * HTTP1.0 エラーコード :Unauthorized パスワードが必要なサイトにパスワード無しでアクセスした時.
     */
    public static final int HTTP10_401 = 401 ;
    
    /**
     * HTTP1.0 エラーコード :Forbidden アクセス権限がない人が訪ねてきた時.
     */
    public static final int HTTP10_403 = 403 ;
    
    /**
     * HTTP1.0 エラーコード :Not Found 打ち込んだURLが存在しない時.
     */
    public static final int HTTP10_404 = 404 ;
    
    /**
     * HTTP1.0 エラーコード :Internal Server Error サーバー内でエラーが発生していて正常送信出来ない時.
     */
    public static final int HTTP10_500 = 500 ;
    
    /**
     * HTTP1.0 エラーコード :Not Implemented サーバーのバージョンとホームページの書式があってない時.
     */
    public static final int HTTP10_501 = 501 ;
    
    /**
     * HTTP1.0 エラーコード :Bad Gateway Proxyサーバーを利用しているとき大元のサーバーでエラーが発生した時.
     */
    public static final int HTTP10_502 = 502 ;
    
    /**
     * HTTP1.0 エラーコード :Service Unavailable 混雑が激しくサーバーがページを表示する余力がない時.
     */
    public static final int HTTP10_503 = 503 ;
    
    /**
     * HTTP1.1 エラーコード :Continue リクエストを続行することが出来る時.
     */
    public static final int HTTP11_100 = 100 ;
    
    /**
     * HTTP1.1 エラーコード :Switching Protocols Upgradeヘッダーフィールドに示すプロトコルの変更.
     */
    public static final int HTTP11_101 = 101 ;
    
    /**
     * HTTP1.1 エラーコード :OK 正常送信.
     */
    public static final int HTTP11_200 = 200 ;
    
    /**
     * HTTP1.1 エラーコード :Created 別の場所からデータを送る時に送信される.
     */
    public static final int HTTP11_201 = 201 ;
    
    /**
     * HTTP1.1 エラーコード :Accepted CGIのように別な場所でデータを作成する時など.
     */
    public static final int HTTP11_202 = 202 ;
    
    /**
     * HTTP1.1 エラーコード :Non-Authoritative Information.
     */
    public static final int HTTP11_203 = 203 ;
    
    /**
     * HTTP1.1 エラーコード :No Content 空のページへアクセスしようとした時.
     */
    public static final int HTTP11_204 = 204 ;
    
    /**
     * HTTP1.1 エラーコード :Reset Content 入力フォームのクリア.
     */
    public static final int HTTP11_205 = 205 ;
    
    /**
     * HTTP1.1 エラーコード :Partial Content 部分的なGETリクエストを完了した時.
     */
    public static final int HTTP11_206 = 206 ;
    
    /**
     * HTTP1.1 エラーコード :Multiple Choices ページ内に同じ画像を２つ以上使う場合.
     */
    public static final int HTTP11_300 = 300 ;
    
    /**
     * HTTP1.1 エラーコード :Moved Permanently サイトが別の場所へ移動した時.
     */
    public static final int HTTP11_301 = 301 ;
    
    /**
     * HTTP1.1 エラーコード :Moved Temporarily サイトが一時的に移動した時.
     */
    public static final int HTTP11_302 = 302 ;
    
    /**
     * HTTP1.1 エラーコード :See Other LocationヘッダのURLを参照.
     */
    public static final int HTTP11_303 = 303 ;
    
    /**
     * HTTP1.1 エラーコード :Not Modified 更新されていない時.
     */
    public static final int HTTP11_304 = 304 ;
    
    /**
     * HTTP1.1 エラーコード :Use Proxy Locationヘッダーフィールドに示すProxyサーバーを経由しなければならない時.
     */
    public static final int HTTP11_305 = 305 ;
    
    /**
     * HTTP1.1 エラーコード :Moved Temporarily サイトが一時的に移動した時.
     */
    public static final int HTTP11_307 = 307 ;
    
    /**
     * HTTP1.1 エラーコード :Bad Request 打ち込んだURLが変に間違った時.
     */
    public static final int HTTP11_400 = 400 ;
    
    /**
     * HTTP1.1 エラーコード :Unauthorized パスワードが必要なサイトにパスワード無しでアクセスした時.
     */
    public static final int HTTP11_401 = 401 ;
    
    /**
     * HTTP1.1 エラーコード :Payment Required 有料ページの時.
     */
    public static final int HTTP11_402 = 402 ;
    
    /**
     * HTTP1.1 エラーコード :Forbidden アクセス権限がない人が訪ねてきた時.
     */
    public static final int HTTP11_403 = 403 ;
    
    /**
     * HTTP1.1 エラーコード :Not Found 打ち込んだURLが存在しない時.
     */
    public static final int HTTP11_404 = 404 ;
    
    /**
     * HTTP1.1 エラーコード :Method Not Allowed リクエストURLに対する無効メソッド.
     */
    public static final int HTTP11_405 = 405 ;
    
    /**
     * HTTP1.1 エラーコード :Not Acceptable リクエストURLはクライアントが想定するものでない時.
     */
    public static final int HTTP11_406 = 406 ;
    
    /**
     * HTTP1.1 エラーコード :Proxy Authentication Required Proxyサーバーの認証が必要である時.
     */
    public static final int HTTP11_407 = 407 ;
    
    /**
     * HTTP1.1 エラーコード :Request Time-out タイムアウトが発生した時.
     */
    public static final int HTTP11_408 = 408 ;
    
    /**
     * HTTP1.1 エラーコード :Conflict リソース競合が発生した時.
     */
    public static final int HTTP11_409 = 409 ;
    
    /**
     * HTTP1.1 エラーコード :Gone リクエストURL削除.
     */
    public static final int HTTP11_410 = 410 ;
    
    /**
     * HTTP1.1 エラーコード :Length Required 長さが足りなかった時.
     */
    public static final int HTTP11_411 = 411 ;
    
    /**
     * HTTP1.1 エラーコード :Precondition Failed 準備が失敗した時.
     */
    public static final int HTTP11_412 = 412 ;
    
    /**
     * HTTP1.1 エラーコード :Request Entity Too Large 対象が大きすぎる時.
     */
    public static final int HTTP11_413 = 413 ;
    
    /**
     * HTTP1.1 エラーコード :Request-URI Too Large URIが大きすぎる時.
     */
    public static final int HTTP11_414 = 414 ;
    
    /**
     * HTTP1.1 エラーコード :Unsupported Media Type ファイルタイプがサポートされていない時.
     */
    public static final int HTTP11_415 = 415 ;
    
    /**
     * HTTP1.1 エラーコード :Requested range not satisfiable レンジ要求が失敗した場合.
     */
    public static final int HTTP11_416 = 416 ;
    
    /**
     * HTTP1.1 エラーコード :Expectation Failed Expect ヘッダで指定された拡張要求は失敗しました.
     */
    public static final int HTTP11_417 = 417 ;
    
    /**
     * HTTP1.1 エラーコード :Internal Server Error サーバー内でエラーが発生していて正常送信出来ない時.
     */
    public static final int HTTP11_500 = 500 ;
    
    /**
     * HTTP1.1 エラーコード :Not Implemented サーバーのバージョンとホームページの書式があってない時.
     */
    public static final int HTTP11_501 = 501 ;
    
    /**
     * HTTP1.1 エラーコード :Bad Gateway Proxyサーバーを利用しているとき大元のサーバーでエラーが発生した時.
     */
    public static final int HTTP11_502 = 502 ;
    
    /**
     * HTTP1.1 エラーコード :Service Unavailable 混雑が激しくサーバーがページを表示する余力がない時.
     */
    public static final int HTTP11_503 = 503 ;
    
    /**
     * HTTP1.1 エラーコード :Gateway Time-out ゲートウェイのタイムアウト.
     */
    public static final int HTTP11_504 = 504 ;
    
    /**
     * HTTP1.1 エラーコード :HTTP Version not supported リクエストされたHTTPのバージョンがサポートされていない時.
     */
    public static final int HTTP11_505 = 505 ;
    
    /**
     * 基本エラーコード : 正常.
     */
    public static final int SUCESS = HttpdErrorDef.HTTP11_200 ;
    
    /**
     * 基本エラーコード : 部分的なGETリクエストを完了.
     */
    public static final int RANGE_GET_OK = HttpdErrorDef.HTTP11_206 ;
    
    /**
     * 基本エラーコード : キャッシュ存在検知.
     */
    public static final int NOT_MEDIFIED = HttpdErrorDef.HTTP11_304 ;
    
    /**
     * 基本エラーコード : URL不正.
     */
    public static final int BAD_REQUEST = HttpdErrorDef.HTTP11_400 ;
    
    /**
     * 基本エラーコード : 認証に失敗.
     */
    public static final int NOT_ATTESTATION = HttpdErrorDef.HTTP11_401 ;
    
    /**
     * 基本エラーコード : 指定内容にアクセス権がない.
     */
    public static final int FORBIDDEN = HttpdErrorDef.HTTP11_403 ;
    
    /**
     * 基本エラーコード : 対象条件が存在しない.
     */
    public static final int NOT_FOUND = HttpdErrorDef.HTTP11_404 ;
    
    /**
     * 基本エラーコード : 対象メソッドがサポート外.
     */
    public static final int NOT_METHOD = HttpdErrorDef.HTTP11_405 ;
    
    /**
     * 基本エラーコード : 対象日付範囲外.
     */
    public static final int PRECONDITION_FAILED = HttpdErrorDef.HTTP11_412 ;
    
    /**
     * 基本エラーコード : レンジ処理失敗.
     */
    public static final int NOT_RANGE = HttpdErrorDef.HTTP11_416 ;
    
    /**
     * 基本エラーコード : サーバエラー.
     */
    public static final int INTERNAL_SERVER_ERROR = HttpdErrorDef.HTTP11_500 ;
    
    /**
     * 基本エラーコード : CGIなど実行時に失敗.
     */
    public static final int ERROR_EXECUTION = HttpdErrorDef.HTTP11_500 ;
    
    /**
     * 基本エラーコード : サーバ負荷による応答不可能.
     */
    public static final int SV_UNAVAILABLE = HttpdErrorDef.HTTP11_503 ;
    
    /**
     * 対象エラーコードを文字列に変換.
     * <BR><BR>
     * 対象エラーコードを文字列に変換します.
     * <BR>
     * @param err 対象のエラーコードを設定します.
     * @return String エラーコードに対する文字列が返されます.
     */
    public static final String convertErrorMessage( int err ) {
        String ret = null ;
        switch( err ){
            case HttpdErrorDef.HTTP11_100 : ret = "Continue" ; break ;
            case HttpdErrorDef.HTTP11_101 : ret = "Switching Protocols" ; break ;
            case HttpdErrorDef.HTTP11_200 : ret = "OK" ; break ;
            case HttpdErrorDef.HTTP11_201 : ret = "Created" ; break ;
            case HttpdErrorDef.HTTP11_202 : ret = "Accepted" ; break ;
            case HttpdErrorDef.HTTP11_203 : ret = "Non-Authoritative Information" ; break ;
            case HttpdErrorDef.HTTP11_204 : ret = "No Content" ; break ;
            case HttpdErrorDef.HTTP11_205 : ret = "Reset Content" ; break ;
            case HttpdErrorDef.HTTP11_206 : ret = "Partial Content" ; break ;
            case HttpdErrorDef.HTTP11_300 : ret = "Multiple Choices" ; break ;
            case HttpdErrorDef.HTTP11_301 : ret = "Moved Permanently" ; break ;
            case HttpdErrorDef.HTTP11_302 : ret = "Moved Temporarily" ; break ;
            case HttpdErrorDef.HTTP11_303 : ret = "See Other" ; break ;
            case HttpdErrorDef.HTTP11_304 : ret = "Not Modified" ; break ;
            case HttpdErrorDef.HTTP11_305 : ret = "Use Proxy" ; break ;
            case HttpdErrorDef.HTTP11_307 : ret = "Temporary Redirect" ; break ;
            case HttpdErrorDef.HTTP11_400 : ret = "Bad Request" ; break ;
            case HttpdErrorDef.HTTP11_401 : ret = "Authorization Required" ; break ;
            case HttpdErrorDef.HTTP11_402 : ret = "Payment Required" ; break ;
            case HttpdErrorDef.HTTP11_403 : ret = "Forbidden" ; break ;
            case HttpdErrorDef.HTTP11_404 : ret = "Not Found" ; break ;
            case HttpdErrorDef.HTTP11_405 : ret = "Method Not Allowed" ; break ;
            case HttpdErrorDef.HTTP11_406 : ret = "Not Acceptable" ; break ;
            case HttpdErrorDef.HTTP11_407 : ret = "Proxy Authentication Required" ; break ;
            case HttpdErrorDef.HTTP11_408 : ret = "Request Time-out" ; break ;
            case HttpdErrorDef.HTTP11_409 : ret = "Conflict" ; break ;
            case HttpdErrorDef.HTTP11_410 : ret = "Gone" ; break ;
            case HttpdErrorDef.HTTP11_411 : ret = "Length Required" ; break ;
            case HttpdErrorDef.HTTP11_412 : ret = "Precondition Failed" ; break ;
            case HttpdErrorDef.HTTP11_413 : ret = "Request Entity Too Large" ; break ;
            case HttpdErrorDef.HTTP11_414 : ret = "Request-URI Too Large" ; break ;
            case HttpdErrorDef.HTTP11_415 : ret = "Unsupported Media Type" ; break ;
            case HttpdErrorDef.HTTP11_416 : ret = "Requested range not satisfiable" ; break ;
            case HttpdErrorDef.HTTP11_417 : ret = "Expectation Failed" ; break ;
            case HttpdErrorDef.HTTP11_500 : ret = "Internal Server Error" ; break ;
            case HttpdErrorDef.HTTP11_501 : ret = "Not Implemented" ; break ;
            case HttpdErrorDef.HTTP11_502 : ret = "Bad Gateway" ; break ;
            case HttpdErrorDef.HTTP11_503 : ret = "Service Unavailable" ; break ;
            case HttpdErrorDef.HTTP11_504 : ret = "Gateway Time-out" ; break ;
            case HttpdErrorDef.HTTP11_505 : ret = "HTTP Version not supported" ; break ;
            default : ret = "Unknown Error" ; break ;
        }
        return ret ;
    }
}

