package org.maachang.comet.httpd.engine;

import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.util.StringUtil;

/**
 * Javascript(js)ファイルを送信するときの予約変数置き換え処理.
 * 
 * @version 2008/05/20
 * @author masahito suzuki
 * @since MaachangComet 1.15
 */
public class EvalJavascript {
    
    /**
     * 予約変数置き換え.
     * @param request 対象のリクエストを設定します.
     * @param string 対象の文字列を設定します.
     * @return String 変換された文字列が返されます.
     * @exception Exception 例外.
     */
    public static final String convert( HttpdRequest request,String string )
    	throws Exception {
        if( request == null ) {
            return string ;
        }
        if( string == null || string.length() <= 0 ) {
            return "" ;
        }
        HttpdSession session = request.getSession() ;
        if( session == null || session.getSessionId() == null ) {
            return string ;
        }
        string = StringUtil.changeString( string,"${SESSION_ID}",session.getSessionId() ) ;
        return string ;
    }
}

