package org.maachang.comet.net ;

import java.io.IOException;
import java.io.InputStream;

/**
 * HttpSocket用受信ストリーム.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpInputStream extends InputStream {
    
    private InputStream inputStream = null ;
    
    private HttpInputStream() {}
    
    public HttpInputStream( InputStream i )
        throws Exception {
        this.inputStream = i ;
    }
    
    protected void finalize() throws Exception {
        this.close() ;
    }
    
    public void close() throws IOException {
        if( isClosed() == false ) {
            this.inputStream = null ;
        }
    }
    
    public int read() throws IOException {
        if( isClosed() == false ) {
            return this.inputStream.read() ;
        }
        return -1 ;
    }
    
    public int read(byte b[]) throws IOException {
        if( isClosed() == false ) {
            return this.inputStream.read(b) ;
        }
        return -1 ;
    }
    
    public int read(byte b[], int off, int len) throws IOException {
        if( isClosed() == false ) {
            return this.inputStream.read(b,off,len) ;
        }
        return -1 ;
    }
    
    public long skip(long n) throws IOException {
        if( isClosed() == false ) {
            return this.inputStream.skip(n) ;
        }
        return 0L ;
    }
    
    public int available() throws IOException {
        if( isClosed() == false ) {
            return this.inputStream.available() ;
        }
        return 0 ;
    }
    
    public void mark(int readlimit) {
        if( isClosed() == false ) {
            this.inputStream.mark(readlimit) ;
        }
    }
    
    public void reset() throws IOException {
        if( isClosed() == false ) {
            this.inputStream.reset() ;
        }
    }
    
    public boolean markSupported() {
        if( isClosed() == false ) {
            return this.inputStream.markSupported() ;
        }
        return false ;
    }
    
    public InputStream inputStream() {
        if( isClosed() == false ) {
            return this.inputStream ;
        }
        return null ;
    }
    
    public boolean isClosed() {
        if( this.inputStream == null ) {
            return true ;
        }
        return false ;
    }
}

