/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import org.maachang.comet.CsvToIndexMdbmBean;
import org.maachang.comet.httpd.engine.script.image.ImageManager;
import org.maachang.comet.httpd.engine.script.image.ImageOp;
import org.maachang.conf.Config;
import org.maachang.conf.ConvIniParam;
import org.maachang.conf.ReadIni;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;

public class CsvToIndexMdbm {
    private static final String ARGS_CSV = "-f";
    private static final String ARGS_HEADER = "-h";
    private static final String ARGS_KEY_HEAD = "-k";
    private static final String ARGS_INDEX = "-i";
    private static final String ARGS_MODE = "-m";
    private static final String ARGS_CHARSET = "-c";
    private static final String MODE_CONNECT_REMOTE = "R";
    private static final String DEFAULT_CHARSET = "WINDOWS-31J";

    public static final void main(String[] args) throws Exception {
        CsvToIndexMdbmBean bean = CsvToIndexMdbm.getCsvToIndexMdbmBean(args);
        if (bean == null) {
            CsvToIndexMdbm.viewHelp();
            return;
        }
        System.out.println("*** Csv2Index by MDBM. ***");
        System.out.println();
        System.out.println("csvFile:" + bean.getCsv());
        System.out.println("keyHead:" + bean.getKeyHead());
        System.out.println();
        if (bean.getHead() != null) {
            if (bean.getIndex() <= -1 && bean.getHead() == null) {
                CsvToIndexMdbm.viewHelp();
                return;
            }
            System.out.println("headFile:" + bean.getHead());
            System.out.println("index:" + bean.getIndex());
        } else {
            System.out.println("headFile:\u76f4\u63a5\u5165\u529b\u30e2\u30fc\u30c9");
        }
        System.out.println("charset:" + bean.getCharset());
        System.out.println();
        MDbm mdbm = null;
        if (bean.getMode() != null && bean.getMode().startsWith(MODE_CONNECT_REMOTE)) {
            System.out.println("MDBM\u306b\u5bfe\u3057\u3066\u3001\u30ea\u30e2\u30fc\u30c8\u63a5\u7d9a\u3067\u51e6\u7406\u3057\u307e\u3059");
            mdbm = CsvToIndexMdbm.connectMDBM();
        } else {
            System.out.println("MDBM\u306b\u5bfe\u3057\u3066\u3001\u76f4\u63a5\u63a5\u7d9a\u3067\u51e6\u7406\u3057\u307e\u3059");
            mdbm = CsvToIndexMdbm.localMDBM();
        }
        if (mdbm == null) {
            System.out.println("MDBM\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f.");
        }
        System.out.println();
        if (bean.getHead() != null) {
            CsvToIndexMdbm.getHeader(bean);
        }
        BufferedReader br = null;
        try {
            try {
                String one;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bean.getCsv()), bean.getCharset()));
                long time = System.currentTimeMillis();
                long nextTime = System.currentTimeMillis();
                int cnt = 0;
                int viewCnt = 0;
                int errorCnt = 0;
                System.out.print("\u9032\u884c:");
                while ((one = br.readLine()) != null) {
                    if ((one = one.trim()).length() <= 0) continue;
                    String data = null;
                    String key = null;
                    if (bean.getHead() != null) {
                        String[] headerKeys = bean.getHeaderData();
                        ArrayList olst = DbUtil.cutCsv((boolean)false, (String)one, (String)",");
                        if (olst == null || olst.size() != headerKeys.length) {
                            ++errorCnt;
                            continue;
                        }
                        int len = olst.size();
                        StringBuilder buf = new StringBuilder();
                        buf.append("[{");
                        int i = 0;
                        while (i < len) {
                            if (i != 0) {
                                buf.append(",");
                            }
                            buf.append("'").append(headerKeys[i]).append("':");
                            String z = (String)olst.get(i);
                            z = z.trim();
                            if (z.length() > 0 && !z.startsWith("'")) {
                                if (z.startsWith("new Date(")) {
                                    buf.append((String)olst.get(i));
                                } else {
                                    buf.append("'").append((String)olst.get(i)).append("'");
                                }
                            } else {
                                buf.append((String)olst.get(i));
                            }
                            ++i;
                        }
                        buf.append("}];");
                        data = buf.toString();
                        key = ((String)olst.get(bean.getIndex())).trim();
                    } else {
                        int p = one.indexOf(",");
                        if (p <= -1) {
                            ++errorCnt;
                            continue;
                        }
                        key = one.substring(0, p);
                        key = key.trim();
                        data = one.substring(p + 1).trim();
                        if (!data.startsWith("[") && !data.endsWith("]")) {
                            data = "[" + data + "]";
                        }
                        if (data.endsWith(";")) {
                            data = String.valueOf(data) + ";";
                        }
                    }
                    if (key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    if (bean.getKeyHead() != null) {
                        key = String.valueOf(bean.getKeyHead()) + key;
                    }
                    mdbm.put(key.getBytes("UTF8"), data.getBytes("UTF8"));
                    ++cnt;
                    if (++viewCnt < 100) continue;
                    System.out.print("\u25a0");
                    if (cnt >= 3000 && cnt % 3000 == 0) {
                        System.out.print("-" + (System.currentTimeMillis() - nextTime) + "msec\n\u3000\u3000 ");
                        nextTime = System.currentTimeMillis();
                    }
                    viewCnt = 0;
                }
                System.out.println("\n exit : " + cnt + " - " + (System.currentTimeMillis() - time) + "msec...");
                System.out.println("error :" + errorCnt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void viewHelp() {
        System.out.println("csv2mdbm [-f] [-k] [-h] [-i] [-m]");
        System.out.println("     [-f] CSV\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059.          \u203b\u5fc5\u9808");
        System.out.println("     [-k] Key\u306b\u4ed8\u52a0\u3059\u308b\u30d8\u30c3\u30c0\u540d\u3092\u8a2d\u5b9a\u3057\u307e\u3059.\u203bCSV:\u5fc5\u9808");
        System.out.println("     [-h] \u30d8\u30c3\u30c0CSV\u30d5\u30a1\u30a4\u30eb\u3092\u8a2d\u5b9a\u3057\u307e\u3059.    \u203bCSV:\u5fc5\u9808");
        System.out.println("     [-i] Index\u9805\u756a\u3092\u8a2d\u5b9a\u3057\u307e\u3059.            \u203bCSV:\u5fc5\u9808");
        System.out.println("     [-c] charset\u3092\u8a2d\u5b9a\u3057\u307e\u3059.default\u306f[SHITF_JIS]\u3067\u3059.");
        System.out.println("     [-m] \u63a5\u7d9a\u30e2\u30fc\u30c9\u3092\u8a2d\u5b9a\u3057\u307e\u3059.");
        System.out.println("          B \u76f4\u63a5MDBM\u306b\u63a5\u7d9a\u3057\u307e\u3059.");
        System.out.println("          R \u30ea\u30e2\u30fc\u30c8\u63a5\u7d9a\u3057\u307e\u3059.");
        System.out.println("            \u307e\u305f\u63a5\u7d9a\u30e2\u30fc\u30c9\u3092\u8a2d\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001B\u3068\u540c\u3058\u3067\u3059.");
        System.out.println();
        System.out.println(" \u307e\u305f\u3001[-h][-i]\u3092\u9664\u5916\u3057\u305f\u5834\u5408\u3001\uff11\u884c\u30c7\u30fc\u30bf\u3092\u76f4\u63a5\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8");
        System.out.println(" \u3057\u307e\u3059.\u3053\u306e\u3068\u304d\u306eIndex\u306f\u3001\u5148\u982d\u304b\u3089\u30ab\u30f3\u30de\u307e\u3067\u306e\u6587\u5b57\u304c\u3001");
        System.out.println(" \u3068\u306a\u308a\u307e\u3059.\u305d\u3057\u3066\u3001\u305d\u306eIndex\u5024\u306f\u683c\u7d0d\u30c7\u30fc\u30bf\u304b\u3089\u9664\u5916\u3055\u308c\u307e\u3059.");
        System.out.println(" \u307e\u305f\u3001\u3053\u306e\u6761\u4ef6\u306f\u3001JSON\u5f62\u5f0f\u306e\u30c7\u30fc\u30bf\u3092\u76f4\u63a5\u30bb\u30c3\u30c8\u3059\u308b\u5834\u5408\u306b\u6709\u52b9\u3067\u3059.");
        System.out.println();
        System.out.println(" \uff11\u884c\u30c7\u30fc\u30bf\u3092CSV\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8\u3059\u308b\u5834\u5408\u306f\u3001\u300c\u203bCSV:\u5fc5\u9808\u300d\u500b\u6240\u304c");
        System.out.println(" \u5fc5\u9808\u5165\u529b\u3068\u306a\u308a\u307e\u3059.");
    }

    private static final CsvToIndexMdbmBean getCsvToIndexMdbmBean(String[] args) {
        if (args.length <= 0 || "--help".equals(args[0])) {
            return null;
        }
        CsvToIndexMdbmBean ret = new CsvToIndexMdbmBean();
        int len = args.length;
        int i = 0;
        while (i < len) {
            String s = args[i];
            if (s != null && (s = s.trim()).length() > 0) {
                if (s.startsWith(ARGS_CSV)) {
                    s = s.substring(ARGS_CSV.length());
                    if ((s = s.trim()).length() <= 0) {
                        return null;
                    }
                    ret.setCsv(s);
                } else if (s.startsWith(ARGS_HEADER)) {
                    s = s.substring(ARGS_HEADER.length());
                    if ((s = s.trim()).length() <= 0) {
                        return null;
                    }
                    ret.setHead(s);
                } else if (s.startsWith(ARGS_INDEX)) {
                    s = s.substring(ARGS_INDEX.length());
                    if ((s = s.trim()).length() <= 0) {
                        return null;
                    }
                    int x = ConvIniParam.getInt((String)s);
                    if (x <= -1) {
                        return null;
                    }
                    ret.setIndex(x);
                } else if (s.startsWith(ARGS_KEY_HEAD)) {
                    s = s.substring(ARGS_KEY_HEAD.length());
                    if ((s = s.trim()).length() <= 0) {
                        return null;
                    }
                    if (!s.endsWith(".")) {
                        s = String.valueOf(s) + ".";
                    }
                    ret.setKeyHead(s);
                } else if (s.startsWith(ARGS_MODE)) {
                    s = s.substring(ARGS_MODE.length());
                    if ((s = s.trim()).length() > 0) {
                        ret.setMode(s);
                    }
                } else if (s.startsWith(ARGS_CHARSET)) {
                    s = s.substring(ARGS_CHARSET.length());
                    if ((s = s.trim()).length() > 0) {
                        ret.setCharset(s);
                    }
                }
            }
            ++i;
        }
        if (ret.getCsv() == null) {
            return null;
        }
        if (ret.getCharset() == null) {
            ret.setCharset(DEFAULT_CHARSET);
        }
        return ret;
    }

    private static final MDbm localMDBM() throws Exception {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./conf/mdbm.conf"), "UTF8"));
            Config conf = new Config();
            ReadIni.analisys((Config)conf, (BufferedReader)br);
            br.close();
            br = null;
            MDbmManager.getInstance().open(conf.get("mdbm", "directory", 0));
            ImageOp op = ImageManager.getImageOp(false);
            MDbm mDbm = op.getMDbm();
            return mDbm;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final MDbm connectMDBM() throws Exception {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./conf/mdbm.conf"), "UTF8"));
            Config conf = new Config();
            ReadIni.analisys((Config)conf, (BufferedReader)br);
            br.close();
            br = null;
            if (!ConvIniParam.getBoolean((String)conf.get("mdbm", "flag", 0))) {
                throw new IOException("\u63a5\u7d9a\u30e2\u30fc\u30c9\u306fOFF\u306b\u306a\u3063\u3066\u3044\u307e\u3059");
            }
            ImageOp op = ImageManager.getImageOp(InetAddress.getByName("127.0.0.1"), conf.getInt("mdbm", "bind-port", 0));
            MDbm mDbm = op.getMDbm();
            return mDbm;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void getHeader(CsvToIndexMdbmBean bean) throws Exception {
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bean.getHead()), bean.getCharset()));
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).length() <= 0) continue;
                ArrayList lst = DbUtil.cutCsv((boolean)false, (String)s, (String)",");
                int len = lst.size();
                if (len <= 0) {
                    throw new IOException("\u30d8\u30c3\u30c0\uff23\uff33\uff36\u306e\u30b5\u30a4\u30ba\u4e0d\u6b63");
                }
                String[] headerLst = new String[len];
                int i = 0;
                while (i < len) {
                    String name;
                    headerLst[i] = name = DbUtil.convertDBNameByJavaName((boolean)false, (String)((String)lst.get(i)));
                    ++i;
                }
                bean.setHeaderData(headerLst);
                break;
            }
            br.close();
            br = null;
            if (bean.getHead() == null) {
                throw new IOException("\u30d8\u30c3\u30c0\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

