/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.FileInputStream;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.maachang.comet.net.SslOption;

public class SslServerFactory {
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private SslOption sslOption = null;

    private SslServerFactory() {
    }

    public SslServerFactory(SslOption option) throws Exception {
        if (option == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        KeyManagerFactory keyFactory = null;
        if (option.getKeyStoreFile() != null && option.getKeyStore() != null && option.getKeyManagerAlgorithm() != null) {
            char[] keyStorePasswd = null;
            if (option.getKeyStorePasswd() != null && option.getKeyStorePasswd().length() > 0) {
                keyStorePasswd = option.getKeyStorePasswd().toCharArray();
            }
            KeyStore keyStore = KeyStore.getInstance(option.getKeyStore());
            keyStore.load(new FileInputStream(option.getKeyStoreFile()), keyStorePasswd);
            keyFactory = KeyManagerFactory.getInstance(option.getKeyManagerAlgorithm());
            keyFactory.init(keyStore, keyStorePasswd);
        }
        TrustManagerFactory trustFactory = null;
        if (option.getTrustFile() != null && option.getTrustStore() != null && option.getTrustKeyManagerAlgorithm() != null) {
            char[] trustPasswd = null;
            if (option.getTrustPassword() != null && option.getTrustPassword().length() > 0) {
                trustPasswd = option.getTrustPassword().toCharArray();
            }
            KeyStore trust = KeyStore.getInstance(option.getTrustStore());
            trust.load(new FileInputStream(option.getTrustFile()), trustPasswd);
            trustFactory = TrustManagerFactory.getInstance(option.getTrustKeyManagerAlgorithm());
            trustFactory.init(trust);
        }
        SecureRandom prng = null;
        if (option.getRandomAlgorithm() != null) {
            prng = SecureRandom.getInstance(option.getRandomAlgorithm());
        }
        SSLContext context = SSLContext.getInstance(option.getSslProtocol());
        context.init(keyFactory.getKeyManagers(), trustFactory.getTrustManagers(), prng);
        this.sslServerSocketFactory = context.getServerSocketFactory();
        this.sslOption = option;
    }

    protected void finalize() throws Exception {
        this.sslServerSocketFactory = null;
        this.sslOption = null;
    }

    public ServerSocket serverSocket() throws Exception {
        ServerSocket ret = this.sslServerSocketFactory.createServerSocket();
        if (this.sslOption.isClientAuth()) {
            ((SSLServerSocket)ret).setNeedClientAuth(true);
        }
        return ret;
    }

    public SslOption getSslOption() {
        return this.sslOption;
    }
}

