/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbmSession {
    private static final Log LOG = LogFactory.getLog(DbmSession.class);
    public static final int RECEIVE_TIMEOUT = 30000;
    private static final long HEAT_BEAT_TIMING = 5000L;
    private static final int MAX_HEART_BEAT = 3;
    private static final int BUFFER = 131072;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private MDbm mdbm = null;
    private String ipPort = null;
    private Enumeration<byte[]> keys = null;
    private long heartBeat = -1L;
    private boolean heartBeatFlag = false;
    private int heartBeatTiming = 0;

    private DbmSession() {
    }

    public DbmSession(Socket socket) throws Exception {
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("\u63a5\u7d9a\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.socket = socket;
            this.socket.setSendBufferSize(131072);
            this.socket.setReceiveBufferSize(131072);
            this.socket.setKeepAlive(true);
            this.socket.setTcpNoDelay(true);
            this.socket.setReuseAddress(true);
            this.socket.setSoLinger(false, 0);
            this.socket.setSoTimeout(30000);
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.mdbm = MDbmManager.getInstance().getMDbm(true);
            this.ipPort = this.socket.getInetAddress().getHostName() + "/" + this.socket.getPort();
            this.heartBeat = System.currentTimeMillis() + 5000L;
            this.heartBeatFlag = false;
            this.heartBeatTiming = 0;
        }
        catch (Exception e) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.socket != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("## MDBM:[" + System.currentTimeMillis() + "]:_close:" + this.ipPort));
        }
        if (this.mdbm != null) {
            try {
                this.mdbm.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.mdbm = null;
        this.keys = null;
        this.heartBeat = -1L;
        this.heartBeatFlag = true;
        this.heartBeatTiming = 0;
    }

    public synchronized boolean isClosed() {
        boolean ret = false;
        try {
            if (this.socket == null || !this.socket.isBound() || this.socket.isClosed() || this.mdbm == null || !this.mdbm.isUse()) {
                this.destroy();
                ret = true;
            }
            ret = false;
        }
        catch (Exception e) {
            this.destroy();
            ret = true;
        }
        return ret;
    }

    public synchronized void heartBeat() throws Exception {
        try {
            if (this.heartBeat >= 0L) {
                long nowTime = System.currentTimeMillis();
                if (!this.heartBeatFlag && this.heartBeat <= nowTime) {
                    this.sendHeartBeat();
                    this.heartBeat = nowTime + 5000L;
                    ++this.heartBeatTiming;
                    if (this.heartBeatTiming >= 3) {
                        this.heartBeatFlag = true;
                    }
                } else if (this.heartBeatFlag && this.heartBeat <= nowTime) {
                    this.destroy();
                }
            }
        }
        catch (Exception e) {
            this.destroy();
        }
    }

    public synchronized boolean isReceive() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        boolean ret = false;
        if (this.inputStream().available() > 0) {
            ret = true;
        }
        return ret;
    }

    public synchronized Socket socket() {
        if (this.isClosed()) {
            return null;
        }
        return this.socket;
    }

    public synchronized InputStream inputStream() {
        if (this.isClosed()) {
            return null;
        }
        return this.inputStream;
    }

    public synchronized OutputStream outputStream() {
        if (this.isClosed()) {
            return null;
        }
        return this.outputStream;
    }

    public synchronized MDbm mdbm() {
        return this.mdbm;
    }

    public synchronized void clearKeys() {
        this.keys = null;
    }

    public synchronized Enumeration<byte[]> getKeys() {
        return this.keys;
    }

    public synchronized void setKeys(Enumeration<byte[]> keys) {
        this.keys = keys;
    }

    public synchronized String ipPort() {
        return this.ipPort;
    }

    public synchronized void successHeartBeat() {
        this.heartBeatFlag = false;
        this.heartBeat = System.currentTimeMillis() + 5000L;
        this.heartBeatTiming = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartBeat() throws Exception {
        if (this.outputStream != null) {
            OutputStream outputStream = this.outputStream;
            synchronized (outputStream) {
                this.outputStream.write(ConvertParam.convertInt(0));
                this.outputStream.flush();
            }
        }
    }
}

