/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service.client;

import java.net.InetAddress;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmOp;
import org.maachang.dbm.service.client.ClientConnectManager;
import org.maachang.dbm.service.client.ClientHeartBeatThread;
import org.maachang.dbm.service.client.MDbmConnection;
import org.maachang.dbm.service.client.MDbmOpConnection;

public class MDbmDriverManager {
    private static final int THREAD_LENGTH = 3;
    private static final MDbmDriverManager SNGL = new MDbmDriverManager();
    private int threadLength = 3;
    private ClientConnectManager man = null;
    private ClientHeartBeatThread[] heartBeat = null;
    private final Object sync = new Object();

    public static final MDbm getConnection(String addr) throws Exception {
        return MDbmDriverManager.getConnection(addr, -1);
    }

    public static final MDbm getConnection(InetAddress addr) throws Exception {
        return MDbmDriverManager.getConnection(addr, -1);
    }

    public static final MDbm getConnection(String addr, int port) throws Exception {
        if (addr == null) {
            addr = "127.0.0.1";
        }
        return MDbmDriverManager.getInstance().connection(InetAddress.getByName(addr), port);
    }

    public static final MDbm getConnection(InetAddress addr, int port) throws Exception {
        return MDbmDriverManager.getInstance().connection(addr, port);
    }

    public static final MDbmOp getConnectionOp(String addr) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, -1));
    }

    public static final MDbmOp getConnectionOp(InetAddress addr) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, -1));
    }

    public static final MDbmOp getConnectionOp(String addr, int port) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, port));
    }

    public static final MDbmOp getConnectionOp(InetAddress addr, int port) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, port));
    }

    public synchronized void setThread(int length) {
        if (length <= 3) {
            length = 3;
        }
        if (length >= 25) {
            length = 25;
        }
        this.threadLength = length;
    }

    private MDbmDriverManager() {
    }

    private static final MDbmDriverManager getInstance() {
        return SNGL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MDbm connection(InetAddress addr, int port) throws Exception {
        if (port < 0 || port > 65535) {
            port = 3953;
        }
        MDbmConnection ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = new MDbmConnection(this.sync, addr, port);
            if (this.man == null) {
                this.man = new ClientConnectManager();
                this.heartBeat = new ClientHeartBeatThread[this.threadLength];
                int i = 0;
                while (i < this.threadLength) {
                    this.heartBeat[i] = new ClientHeartBeatThread(this.sync, this.man);
                    ++i;
                }
            }
            this.man.put(ret.clientConnection().getSession());
        }
        return ret;
    }
}

