///////////////////////////////////////////////////////////////////////////////
// maachangComet 基本Javascript.
// Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

// グローバル.
var __VAL_GLOVAL__ = this ;

// ブラウザ判別.
var isMSIE = /*@cc_on!@*/false; 
var isSAFARI = navigator.userAgent.indexOf( "Safari" ) != -1 ;
var isOPERA = navigator.userAgent.indexOf( "Opera" ) != -1 ;
var isMOZILLA = navigator.userAgent.indexOf( "Mozilla/" ) != -1 && isMSIE == false ;
var isNETSCAPE = navigator.userAgent.indexOf( "Netscape" ) != -1 ;

// クッキー判別.
var isCookie = navigator.cookieEnabled ;

///////////////////////////////////////////////////////////////////////////////
// 基本定義.
///////////////////////////////////////////////////////////////////////////////

// getElementById.
$ = function( name ) {
    return document.getElementById( name ) ;
} ;

// bind.
Function.prototype.bind = function(object) {
    var md = this;
    return function() {
        return md.apply(object, arguments);
    }
} ;

// firefox専用デバッグ出力.
dbg = function( str ) {
    if( isMOZILLA == true ) {
        console.debug( str ) ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// baseオブジェクト.
///////////////////////////////////////////////////////////////////////////////
$base = {
    // nullチェック.
    isNull : function( value ) {
        if( value == null || typeof( value ) == "undefined" ) {
            return true ;
        }
        return false ;
    },
    // trim.
    trim : function(arg_value){
        if( this.isNull( arg_value ) == true ||
            arg_value.length <= 0 ) {
            return '' ;
        }
        else if( typeof( arg_value ) != "string" ) {
            return arg_value ;
        }
        for( i = 0; i < arg_value.length ; i ++ ) {
            var old = arg_value ;
            arg_value = arg_value.replace( "&nbsp;"," " ) ;
            if( old.length == arg_value.length ) {
                break ;
            }
        }
        
        var st = 0 ;
        var ed = arg_value.length ;
        var len = arg_value.length ;
        for( i = 0 ; i < len ; i ++ ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || x == 160 ) {//x==160はsafari対応.
                st = i+1 ;
            }
            else {
                break ;
            }
        }
        len = arg_value.length-1 ;
        for( i = len ; i >= 0 ; i -- ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || x == 160 ) {//x==160はsafari対応.
                ed = i ;
            }
            else {
                break ;
            }
        }
        if( st >= ed ) {
            return '' ;
        }
        ret = arg_value.substring( 0,ed ) ;
        if( st > 0 ) {
            ret = ret.substring( st ) ;
        }
        return ret ;
    },
    // 文字列を置き換える.
    changeString : function( base,src,dest ) {
        if( this.isNull( base ) ||
            this.isNull( src ) ||
            this.isNull( dest ) ) {
            return "" ;
        }
        var ret = '' ;
        var p = base.indexOf( src ) ;
        if( p == -1 ) {
            return base ;
        }
        if( p == 0 ) {
            ret += dest ;
            ret += base.substring( src.length,base.length ) ;
        }
        else {
            ret += base.substring( 0,p ) ;
            ret += dest ;
            if( src.length != base.length ) {
                ret += base.substring( p+src.length,base.length ) ;
            }
        }
        return ret ;
    },
    // startWith.
    startsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        if( str.indexOf( chk ) == 0 ) {
            return true ;
        }
        return false ;
    },
    // endsWith.
    endsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        var last = str.lastIndexOf( chk ) ;
        if( last != -1 && last == str.length-chk.length ) {
            return true ;
        }
        return false ;
    },
    // 文字存在チェック.
    useString : function(str){
        if( this.isNull( str ) == true || this.trim(str).length <= 0 ) {
            return false ;
        }
        return true ;
    },
    // 数値チェック.
    isNumeric : function(num){
        if( this.useString( num ) == false ) {
            return false ;
        }
        if( this.startsWith( num,"-" ) ) {
            num = num.substring( 1 ) ;
        }
        if (num.match(/[^0-9.0-9]/g)) {
            return false;
        }
        return true;
    },
    // 現在日付を取得
    nowDateString : function(mode) {
        return this.formatDateByString(new Date(),mode) ;
    },
    // 日付を変換.
    formatDateByString : function( date,mode ) {
        if( this.isNull( date ) ) {
            return null ;
        }
        if( this.isNull( mode ) ) {
            mode = false ;
        }
        var ret = "" + date.getFullYear() ;
        var x = ""+(date.getMonth()+1) ;
        ret += "/" + "00".substring( x.length,2 ) + x ;
        x = ""+date.getDate() ;
        ret += "/" + "00".substring( x.length,2 ) + x ;
        if( mode == true ) {
            ret += " " ;
        }
        else {
            ret += "&nbsp;" ;
        }
        x = ""+date.getHours() ;
        ret += "00".substring( x.length,2 ) + x ;
        x = ""+date.getMinutes() ;
        ret += ":" + "00".substring( x.length,2 ) + x ;
        x = ""+date.getSeconds() ;
        ret += ":" + "00".substring( x.length,2 ) + x ;
        return ret ;
    },
    // 文字をエンコード.
    encodeParam : function(params) {
        if( this.useString( params ) == true ) {
            var x = params.split( "&" ) ;
            var len = x.length ;
            var ret = "" ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( i != 0 ) {
                    ret += "&" ;
                }
                var p = x[i].indexOf( "=" ) ;
                if( p != -1 ) {
                    var k = x[i].substring( 0,p ) ;
                    var v = x[i].substring( p+1,x[i].length ) ;
                    x[i] = k + "=" + encodeURIComponent( v ) ;
                }
                ret += x[i] ;
            }
        }
        return ret ;
    },
    // 現在のURLを取得.
    getURL : function() {
        return document.URL ;
    },
    // 現在のURLから、ドメイン名までを取得.
    getUrlDomain : function() {
        var url = this.getURL() ;
        var p = url.indexOf( "//" ) ;
        if( p <= -1 ) {
            return "" ;
        }
        p = url.indexOf( "/",p+"//".length ) ;
        if( p <= -1 ) {
            return url ;
        }
        return url.substring( 0,p+"/".length ) ;
    },
    // 現在のドメインだけを取得.
    getDomain : function() {
        var url = this.getURL() ;
        var p = url.indexOf( "//" ) ;
        if( p <= -1 ) {
            return "" ;
        }
        var p1 = url.indexOf( "/",p+"//".length ) ;
        if( p1 <= -1 ) {
            return url.substring( p+"//".length ) ;
        }
        return url.substring( p+"//".length,p1 ) ;
    }
} ;


///////////////////////////////////////////////////////////////////////////////
// 例外オブジェクト.
///////////////////////////////////////////////////////////////////////////////

// 基本例外.
var Exception = function(message) {
    this.name = "Exception" ;
    if( $base.useString( message ) ) {
        this.message = message ;
    }
    else {
        this.message = "" ;
    }
} ;
Exception.prototype = new Error;
Exception.prototype.toString = function() {
    if( $base.useString( this.message ) ) {
        return "["+this.name+"] :message "+this.message ;
    }
    return "["+this.name+"]"
} ;

// NullPointerException.
var NullPointerException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
NullPointerException.prototype = new Exception;
NullPointerException.prototype.name = 'NullPointerException';


// IllegalArgumentException.
var IllegalArgumentException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IllegalArgumentException.prototype = new Exception;
IllegalArgumentException.prototype.name = 'IllegalArgumentException';


// IndexOutOfBoundsException.
var IndexOutOfBoundsException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IndexOutOfBoundsException.prototype = new Exception;
IndexOutOfBoundsException.prototype.name = 'IndexOutOfBoundsException';


// IOException.
var IOException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IOException.prototype = new Exception;
IOException.prototype.name = 'IOException';

///////////////////////////////////////////////////////////////////////////////
// デバッグ系.
///////////////////////////////////////////////////////////////////////////////
$debug = {
    // 最大出力文字数.
    maxlength: 65535,
    // element設定フラグ.
    elementFlag: false,
    // デバッグ出力.
    out : function( value ) {
        if( $base.useString( value ) == false ) {
            return ;
        }
        // firefoxの場合は、コンソールに出力.
        if( this.elementFlag == false && isMOZILLA == true ) {
            dbg( "[" + $base.nowDateString() + "] : # " + value + "    " ) ;
        }
        // それ以外の場合は、element設定した内容に出力.
        else {
            $('debugId').innerHTML = "[" + $base.nowDateString() + "]&nbsp;:&nbsp;#&nbsp;" +
                value + "&nbsp;&nbsp;&nbsp;&nbsp;<br>" + $('debugId').innerHTML ;
            var c = $('debugId').innerHTML ;
            if( c.length > this.maxlength ) {
                $('debugId').innerHTML = c.substring( 0,maxlength ) ;
            }
        }
    },
    // デバッグ出力位置を設定.
    element : function(mode) {
        debugTag = document.createElement('div') ;
        debugTag.id="debugId";
        if( $base.isNull( mode ) == false && mode == true ) {
            document.body.appendChild(debugTag) ;
        }
        this.elementFlag = true ;
        return debugTag ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// md5処理.
///////////////////////////////////////////////////////////////////////////////

$md5 = {
    TABLE : new Array(0x00000000, 0xd76aa478, 0xe8c7b756, 0x242070db,
                  0xc1bdceee, 0xf57c0faf, 0x4787c62a, 0xa8304613,
                  0xfd469501, 0x698098d8, 0x8b44f7af, 0xffff5bb1,
                  0x895cd7be, 0x6b901122, 0xfd987193, 0xa679438e,
                  0x49b40821, 0xf61e2562, 0xc040b340, 0x265e5a51,
                  0xe9b6c7aa, 0xd62f105d, 0x02441453, 0xd8a1e681,
                  0xe7d3fbc8, 0x21e1cde6, 0xc33707d6, 0xf4d50d87,
                  0x455a14ed, 0xa9e3e905, 0xfcefa3f8, 0x676f02d9,
                  0x8d2a4c8a, 0xfffa3942, 0x8771f681, 0x6d9d6122,
                  0xfde5380c, 0xa4beea44, 0x4bdecfa9, 0xf6bb4b60,
                  0xbebfbc70, 0x289b7ec6, 0xeaa127fa, 0xd4ef3085,
                  0x04881d05, 0xd9d4d039, 0xe6db99e5, 0x1fa27cf8,
                  0xc4ac5665, 0xf4292244, 0x432aff97, 0xab9423a7,
                  0xfc93a039, 0x655b59c3, 0x8f0ccc92, 0xffeff47d,
                  0x85845dd1, 0x6fa87e4f, 0xfe2ce6e0, 0xa3014314,
                  0x4e0811a1, 0xf7537e82, 0xbd3af235, 0x2ad7d2bb,
                  0xeb86d391),
    ROUND : [
        [function(x, y, z) { return (x & y) | (~x & z); },
        new Array(new Array( 0, 7, 1), new Array( 1,12, 2),
               new Array( 2,17, 3), new Array( 3,22, 4),
               new Array( 4, 7, 5), new Array( 5,12, 6),
               new Array( 6,17, 7), new Array( 7,22, 8),
               new Array( 8, 7, 9), new Array( 9,12,10),
               new Array(10,17,11), new Array(11,22,12),
               new Array(12, 7,13), new Array(13,12,14),
               new Array(14,17,15), new Array(15,22,16)) ],
        [function(x, y, z) { return (x & z) | (y & ~z); },
        new Array(new Array( 1, 5,17), new Array( 6, 9,18),
               new Array(11,14,19), new Array( 0,20,20),
               new Array( 5, 5,21), new Array(10, 9,22),
               new Array(15,14,23), new Array( 4,20,24),
               new Array( 9, 5,25), new Array(14, 9,26),
               new Array( 3,14,27), new Array( 8,20,28),
               new Array(13, 5,29), new Array( 2, 9,30),
               new Array( 7,14,31), new Array(12,20,32)) ],
        [function(x, y, z) { return x ^ y ^ z;          },
        new Array(new Array( 5, 4,33), new Array( 8,11,34),
               new Array(11,16,35), new Array(14,23,36),
               new Array( 1, 4,37), new Array( 4,11,38),
               new Array( 7,16,39), new Array(10,23,40),
               new Array(13, 4,41), new Array( 0,11,42),
               new Array( 3,16,43), new Array( 6,23,44),
               new Array( 9, 4,45), new Array(12,11,46),
               new Array(15,16,47), new Array( 2,23,48)) ],
        [function(x, y, z) { return y ^ (x | ~z);       },
        new Array(new Array( 0, 6,49), new Array( 7,10,50),
               new Array(14,15,51), new Array( 5,21,52),
               new Array(12, 6,53), new Array( 3,10,54),
               new Array(10,15,55), new Array( 1,21,56),
               new Array( 8, 6,57), new Array(15,10,58),
               new Array( 6,15,59), new Array(13,21,60),
               new Array( 4, 6,61), new Array(11,10,62),
               new Array( 2,15,63), new Array( 9,21,64)) ]],
    pack : function(n32) {
      return String.fromCharCode(n32 & 0xff) +
         String.fromCharCode((n32 >>> 8) & 0xff) +
         String.fromCharCode((n32 >>> 16) & 0xff) +
         String.fromCharCode((n32 >>> 24) & 0xff)
    },
    unpack : function(s4) {
      return  s4.charCodeAt(0)        |
         (s4.charCodeAt(1) <<  8) |
         (s4.charCodeAt(2) << 16) |
         (s4.charCodeAt(3) << 24);
    },
    number : function(n) {
      while (n < 0)
        n += 4294967296;
      while (n > 4294967295)
        n -= 4294967296;
      return n;
    },
    apply_round : function(x, s, f, abcd, r) {
      var a, b, c, d;
      var kk, ss, ii;
      var t, u;
      a = abcd[0];
      b = abcd[1];
      c = abcd[2];
      d = abcd[3];
      kk = r[0];
      ss = r[1];
      ii = r[2];
      u = f(s[b], s[c], s[d]);
      t = s[a] + u + x[kk] + this.TABLE[ii];
      t = this.number(t);
      t = ((t<<ss) | (t>>>(32-ss)));
      t += s[b];
      s[a] = this.number(t);
    },
    hash : function(data) {
      var abcd, x, state, s;
      var len, index, padLen, f, r;
      var i, j, k;
      var tmp;
      
      state = new Array(0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476);
      len = data.length;
      index = len & 0x3f;
      padLen = (index < 56) ? (56 - index) : (120 - index);
      if(padLen > 0) {
        data += "\x80";
        for(i = 0; i < padLen - 1; i++)
          data += "\x00";
      }
      data += this.pack(len * 8);
      data += this.pack(0);
      len  += padLen + 8;
      abcd = new Array(0, 1, 2, 3);
      x    = new Array(16);
      s    = new Array(4);
      
      for(k = 0; k < len; k += 64) {
        for(i = 0, j = k; i < 16; i++, j += 4) {
          x[i] = data.charCodeAt(j) |
            (data.charCodeAt(j + 1) <<  8) |
            (data.charCodeAt(j + 2) << 16) |
            (data.charCodeAt(j + 3) << 24);
        }
        for(i = 0; i < 4; i++)
          s[i] = state[i];
        for(i = 0; i < 4; i++) {
          f = this.ROUND[i][0];
          r = this.ROUND[i][1];
          for(j = 0; j < 16; j++) {
            this.apply_round(x, s, f, abcd, r[j]);
            tmp = abcd[0];
            abcd[0] = abcd[3];
            abcd[3] = abcd[2];
            abcd[2] = abcd[1];
            abcd[1] = tmp;
          }
        }
        for(i = 0; i < 4; i++) {
          state[i] += s[i];
          state[i] = this.number(state[i]);
        }
      }
      return this.pack(state[0]) +
         this.pack(state[1]) +
         this.pack(state[2]) +
         this.pack(state[3]);
    },
    hexhash : function(data) {
        var i, out, c;
        var bit128;
        
        bit128 = this.hash(data);
        out = "";
        for(i = 0; i < 16; i++) {
        c = bit128.charCodeAt(i);
        out += "0123456789abcdef".charAt((c>>4) & 0xf);
        out += "0123456789abcdef".charAt(c & 0xf);
        }
        return out;
    }
} ;

// md5変換内容を文字列で取得するメソッド.
md5 = function( data ) {
    return $md5.hexhash( data ) ;
} ;

///////////////////////////////////////////////////////////////////////////////
// 文字列連結オブジェクト.
///////////////////////////////////////////////////////////////////////////////
StringBuffer = function() {}
StringBuffer.prototype = {
    // buffer.
    buf: "",
    // 生成処理.
    create: function() {
        this.buf = "" ;
    },
    // クリア処理.
    clear: function() {
        this.buf = "" ;
    },
    // 連結.
    append: function(str) {
        if( $base.useString( str ) ) {
            return ;
        }
        this.buf += str ;
    },
    // 長さを取得.
    length: function() {
        return this.buf.length ;
    },
    // 内容表示.
    toString: function() {
        return this.buf ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// json変換.
///////////////////////////////////////////////////////////////////////////////
$json = {
    // json形式に変換.
    encode : function( value ) {
        if( $base.isNull( value ) ) {
            return "[\"\"]" ;
        }
        var t = valueof( value ) ;
        if( t == "array" ) {
            t = null ;
            var ret = "" ;
            ret = this.evalByArrayString( ret,value ) ;
            return ret ;
        }
        else if( t == "map" ) {
            t = null ;
            var ret = "[" ;
            this.evalByMapString( ret,value ) ;
            return ret + "]" ;
        }
        return "["+this.evalByString( t,value )+"]" ;
    },
    // json形式の文字列を変換.
    decode : function( value ) {
        if( $base.isNull( value ) || typeof( value ) != "string" ) {
            return null ;
        }
        var ret = eval( value ) ;
        if( $base.isNull( ret ) != null ) {
            if( this.valueof( ret ) == "array" && ret.length == 1 ) {
                ret = ret[ 0 ] ;
            }
            return ret ;
        }
        return null ;
    },
    // Arrayタイプから、eval実行可能内容を生成.
    evalByArrayString : function( o,v ) {
        o += "[" ;
        var len = v.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                o += "," ;
            }
            var t = this.valueof( v[i] ) ;
            if( t == "array" ) {
                o = this.evalByArrayString( o,v[i] ) ;
            }
            else if( t == "map" ) {
                o = this.evalByMapString( o,v[i] ) ;
            }
            else {
                o += this.evalByString( t,v[i] ) ;
            }
        }
        return o + "]" ;
    },
    // Mapタイプから、eval実行可能内容を生成.
    evalByMapString : function( o,v ) {
        o += "{" ;
        var cnt = 0 ;
        for( var k in v ) {
            if( cnt != 0 ) {
                o += "," ;
            }
            o += "\"" + k + "\":" ;
            var t = this.valueof( v[k] ) ;
            if( t == "array" ) {
                o = this.evalByArrayString( o,v[k] ) ;
            }
            else if( t == "map" ) {
                o = this.evalByMapString( o,v[k] ) ;
            }
            else {
                o += this.evalByString( t,v[k] ) ;
            }
            cnt ++ ;
        }
        return o + "}" ;
    },
    // 指定タイプから、eval実行可能内容を生成.
    evalByString : function( t,v ) {
        if( t == "string" ) {
            return "\""+v+"\"" ;
        }
        else if( t == "boolean" ) {
            return ""+v ;
        }
        else if( t == "number" ) {
            return ""+v ;
        }
        else if( t == "date" ) {
            return "new Date(" + v.getTime() + ")" ;
        }
        return "\"\"" ;
    },
    // 指定内容タイプを取得.
    valueof : function( val ) {
        if( $base.isNull( val ) ) {
            return "null" ;
        }
        var t = typeof( val ) ;
        if( t == "string" ) {
            return "string" ;
        }
        if( t == "boolean" ) {
            return "boolean" ;
        }
        else if( t == "number" ) {
            return "number" ;
        }
        else if( t == "function" ) {
            return "function" ;
        }
        else if( t == "object" ) {
            if( val instanceof Date ) {
                return "date" ;
            }
            else if( val instanceof Array ) {
                if( val.length == 0 ) {
                    return "array" ;
                }
                return this.arrayOrMapValueTo( val ) ;
            }
        }
        return this.arrayOrMapValueTo( val ) ;
    },
    // 指定内容タイプがArrayかMapか取得.
    arrayOrMapValueTo : function( val ) {
        var cnt = 0 ;
        var aryFlg = true ;
        for( var k in val ) {
            if( cnt != k ) {
                cnt ++ ;
                aryFlg = false ;
                break ;
            }
            cnt ++ ;
        }
        if( cnt == 0 ) {
            return "object" ;
        }
        if( aryFlg == true ) {
            return "array" ;
        }
        return "map" ;
    }
} ;

// typeof拡張.
var valueof = function(value) {
    return $json.valueof(value) ;
} ;

///////////////////////////////////////////////////////////////////////////////
// RPCオブジェクト.
///////////////////////////////////////////////////////////////////////////////

// RPCオブジェクト.
$rpc = {
    // 戻り値が正常か、エラーかを判別します.
    isError : function( result ) {
        if( $base.isNull( result ) || valueof( result ) != "array" ) {
            return false ;
        }
        if( $base.isNull( result[0].result ) == false &&
            result[0].result == "error" ) {
            return true ;
        }
        return false ;
    },
    // 戻り値データを取得.
    getResult : function( data ) {
        if( $base.isNull( data ) ||
            valueof( data ) != "array" ||
            $base.isNull( data[0].value ) ) {
            return "" ;
        }
        return data[0].value ;
    },
    // メソッド名をURL名に整形.
    _getMethodNameByURL : function( method,fooderName) {
        // メソッド名をURL変換[.区切りを省く].
        var lst = method.split( "." ) ;
        var len = lst.length - 1 ;
        var readUrl = "" ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                readUrl += "/" ;
            }
            readUrl += $base.trim( lst[ i ] ) ;
        }
        var last = $base.trim( lst[ len ] ) ;
        lst = null ;
        var p = last.indexOf( "(" ) ;
        if( p >= 0 ) {
            last = last.substring( 0,p ) ;
        }
        if( $base.endsWith( last,fooderName ) == false ) {
            last = last + fooderName ;
        }
        if( $base.endsWith( last,".ms" ) == false ) {
            last = last + ".ms" ;
        }
        readUrl += "/" + last ;
        last = null ;
        
        // 接続先のURLとして整形.
        if( $base.endsWith( readUrl,"/" ) == false &&
            $base.startsWith( readUrl,"/" ) == false ) {
            readUrl = "/" + readUrl ;
        }
        return readUrl ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// jsonpRPCオブジェクト.
///////////////////////////////////////////////////////////////////////////////

// jsonpRPCオブジェクト.
$jsonpRPC = {
    _counter : 0,
    _methodCounter : 0,
    // jsonpサーバリソースにアクセスするメソッド生成.
    createFunction : function( url,methodName,callFunc ) {
        if( $base.useString( url ) == false || typeof( url ) != "string" ) {
            throw new IllegalArgumentException( "($jsonpRPC.createFunction):urlは不正です" ) ;
        }
        if( $base.isNull( methodName ) || typeof( methodName ) != "string" ) {
            throw new IllegalArgumentException( "($jsonpRPC.createFunction):methodNameは不正です" ) ;
        }
        if( $base.isNull( callFunc ) || typeof( callFunc ) != "function" ) {
            throw new IllegalArgumentException( "($jsonpRPC.createFunction):callFuncは不正です" ) ;
        }
        // URLをセット.
        var urlValue = url ;
        
        // コールバックメソッドをセット.
        var callbackName = "__result_jsnpRpc_"+this._methodCounter+"_"+$base.changeString( methodName,".","_" )+"_"+new Date().getTime() ;
        this._methodCounter ++ ;
        __VAL_GLOVAL__[callbackName] = callFunc ;
        
        // 実行メソッドを生成して戻す.
        return function() {
            // パラメータ引数をJSON形式に変換.
            len = arguments.length ;
            var jargs = [] ;
            for( var i = 0 ; i < len ; i ++ ) {
                var arg = arguments[ i ] ;
                jargs[ jargs.length ] = arg ;
            }
            return $jsonpRPC._execution( urlValue,callbackName,methodName,jargs ) ;
        } ;
    },
    // jsonpRPC実行処理.
    _execution : function(url,callback,method,args) {
        if( $base.useString( url ) == false ) {
            throw new IllegalArgumentException( "($jsonpRPC._execution):urlが指定されていません" ) ;
        }
        else if( $base.useString( callback ) == false ) {
            throw new IllegalArgumentException( "($jsonpRPC._execution):callbackが指定されていません" ) ;
        }
        else if( $base.useString( method ) == false ) {
            throw new IllegalArgumentException( "($jsonpRPC._execution):methodが指定されていません" ) ;
        }
        // スクリプトIDを取得.
        var scriptName = "jrpc-"+md5( url )+"-"+this._counter+"-"+new Date().getTime() ;
        this._counter ++ ;
        // url名に整形.
        var baseUrl = url ;
        if( $base.startsWith( baseUrl,"http://" ) == false &&
            $base.startsWith( baseUrl,"https://" ) == false ) {
            baseUrl = "http://" + baseUrl ;
        }
        // メソッド名をURL変換[.区切りを省く].
        var readUrl = baseUrl + $rpc._getMethodNameByURL( method,"Jsonp" ) ;
        
        // パラメータ引数をJSON形式に変換.
        if( $base.isNull( args ) ) {
            args = [] ;
        }
        // ID追加.
        var params = "jid="+scriptName+"Id" ;
        // JSONP引数.
        if( args.length > 0 ) {
            params += "&jargs="+ encodeURIComponent( $json.encode( args ) ) ;
        }
        // IE以外のアクセスを示す.
        if( isMSIE == false ) {
            params += "&ie=0" ;
        }
        // IEのアクセスを示す.
        else {
            params += "&ie=1" ;
        }
        // コールバックメソッドが存在する場合、その内容をパラメータとしてセット.
        if( $base.useString( callback ) ) {
            var p = callback.indexOf( "(" ) ;
            if( p >= 0 ) {
                callback = callback.substring( 0,p ) ;
            }
            params += "&callback="+encodeURIComponent(callback) ;
        }
        return this._accessjsonp( readUrl,scriptName+"Id",scriptName,params ) ;
    },
    // jsonp接続処理.
    _accessjsonp : function( url,id,name,params ) {
        if( $base.useString( url ) == false ) {
            throw new IllegalArgumentException(
                "($jsonpRPC._accessjsonp):接続先(url)を指定してください" ) ;
        }
        if( $base.useString( params ) ) {
            url += "?" + params ;
        }
        var script = document.createElement('script') ;
        script.charset = 'utf-8' ;
        if( $base.useString( id ) ) {
            script.id = id ;
        }
        if( $base.useString( name ) ) {
            script.name = name ;
        }
        script.src = url ;
        // script呼び出し.
        document.body.appendChild(script) ;
        // script削除(ie以外).
        if( isMSIE == false ) {
            document.body.removeChild(script) ;
        }
        return url ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// ajaxRPCオブジェクト.
///////////////////////////////////////////////////////////////////////////////

// AjaxRPCオブジェクト.
$ajaxRPC = {
    // jsonpサーバリソースにアクセスするメソッド生成.
    createFunction : function( methodName,callFunc ) {
        if( $base.isNull( methodName ) || typeof( methodName ) != "string" ) {
            throw new IllegalArgumentException( "($jsonpRPC.createFunction):methodNameは不正です" ) ;
        }
        if( $base.isNull( callFunc ) || typeof( callFunc ) != "function" ) {
            callFunc = null ;
        }
        
        // 実行メソッド内で利用するパラメータ.
        var methodValue = methodName ;
        var callFuncValue = callFunc ;
        
        // 実行メソッドを生成して戻す.
        return function() {
            var xmlhttp = $ajaxRPC._getXmlHttpObject() ;
            if( $base.isNull( xmlhttp ) ) {
                throw new IOException( "Ajaxオブジェクトの取得に失敗しました" ) ;
            }
            // パラメータ引数をJSON形式に変換.
            var sendParams = null ;
            if( arguments.length <= 0 ) {
                // パラメータを生成.
                sendParams = "ie="+(( isMSIE == false ) ? "0" : "1") +
                    "&_maachang-session=${SESSION_ID}" ;
            }
            else {
                var len = arguments.length ;
                var jargs = [] ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var arg = arguments[ i ] ;
                    jargs[ jargs.length ] = arg ;
                }
                // パラメータを生成.
                sendParams = "jargs="+encodeURIComponent( $json.encode( jargs ) ) +
                    "&ie="+(( isMSIE == false ) ? "0" : "1") +
                    "&_maachang-session=${SESSION_ID}" ;
                jargs = null ;
            }
            return $ajaxRPC._execution( xmlhttp,methodValue,sendParams,callFuncValue ) ;
        } ;
    },
    // ajaxオブジェクトを取得.
    _getXmlHttpObject : function() {
        var xmlhttp = null ;
        if(window.ActiveXObject) {
            try {
                xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                xmlhttp = null ;
            }
            if( $base.isNull( xmlhttp ) ) {
                try {
                    xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
                } catch (e) {
                    xmlhttp = null;
                }
            }
        }
        else if(window.XMLHttpRequest) {
            xmlhttp = new XMLHttpRequest();
        }
        if( $base.isNull( xmlhttp ) ) {
            xmlhttp = new XMLHttpRequest();
            if( isNull( xmlhttp ) ) {
                xmlhttp = null ;
            }
        }
        return xmlhttp ;
    },
    // ajaxオブジェクトでアクセス.
    _execution : function( xmlhttp,method,sendParams,callFunc ) {
        var url = $base.getUrlDomain() ;
        url = url.substring( 0,url.length-1 ) + $rpc._getMethodNameByURL( method,"Rpc" ) ;
        var sync = ( $base.isNull( callFunc ) ) ? "false" : "true" ;
        
        // コネクションオープン.
        xmlhttp.open("POST",url,sync);
        
        // POST用ContentTypeをセット.
        try {
            if( typeof( xmlhttp.setRequestHeader ) == 'function' ) {
                xmlhttp.setRequestHeader( "Content-Type",
                    "application/x-www-form-urlencoded; charset=UTF-8" ) ;
            }
        } catch( e ) {
        }
        
        // 非同期処理の場合.
        if( sync == "true" ) {
            xmlhttp.onreadystatechange = function() {
                if( xmlhttp.readyState == 4 ) {
                    try {
                        // 正常処理.
                        if( xmlhttp.status == 200 ) {
                            var result = xmlhttp.responseText ;
                            callFunc( eval( result ) ) ;
                        }
                    } catch( e ) {
                        // エラー処理.
                        callFunc( [{result:"error",value:e.toString()}] ) ;
                    }
                    // 接続処理終了.
                    try {
                        xmlhttp.abort() ;
                    } catch( e ) {
                    }
                    xmlhttp = null ;
                }
            }
        }
        // 送信処理.
        if( $base.isNull( sendParams ) ) {
            xmlhttp.send() ;
        }
        else {
            xmlhttp.send(sendParams) ;
        }
        // 同期処理の場合.
        if( sync == "false" ) {
            var result = xmlhttp.responseText ;
            // 接続処理終了.
            try {
                xmlhttp.abort() ;
            } catch( e ) {
            }
            xmlhttp = null ;
            return eval( result ) ;
        }
        return "" ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// jsonpRPC by Cometオブジェクト.
///////////////////////////////////////////////////////////////////////////////

// jcometオブジェクト.
$jcomet = {
    _counter : 0,
    _methodCounter : 0,
    // jcomet実行メソッドを生成.
    createFunction : function( url,groupId,cometId,callbackFunc ) {
        if( $base.useString( url ) == false ) {
            throw new IllegalArgumentException( "($jcomet.createFunction):urlを指定してください" ) ;
        }
        else if( $base.useString( groupId ) == false ) {
            throw new IllegalArgumentException( "($jcomet.createFunction):groupIdを指定してください" ) ;
        }
        else if( isNull( callbackFunc ) || typeof( callbackFunc ) != 'function' ) {
            throw new IllegalArgumentException( "($jcomet.createFunction):コールバックメソッドを設定してください" ) ;
        }
        // 基本変数を定義.
        var funcScope = [] ;
        funcScope.url = url ;
        funcScope.groupId = groupId ;
        funcScope.counter = 0 ;
        funcScope.callFunc = callFunc ;
        funcScope.time = -1 ;
        if( useString( cometId ) ) {
            funcScope.cometId = cometId ;
        }
        else {
            funcScope.cometId = 0 ;
        }
        // コールバックメソッド名.
        funcScope.callbackName = "__result_jsnpCmt_"+this._methodCounter+"_"+md5( groupId+funcScope.url )+"_"+new Date().getTime() ;
        this._methodCounter ++ ;
        
        // jcomet実行メソッド.
        funcScope.jcometFunc = function() {
            // パラメータ引数をJSON形式に変換.
            len = arguments.length ;
            var jargs = [] ;
            // 設定引数をセット.
            for( var i = 0 ; i < len ; i ++ ) {
                var arg = arguments[ i ] ;
                jargs[ jargs.length ] = arg ;
            }
            // 実行時間をセット.
            funcScope.time = new Date().getTime() ;
            // jcomet実行.
            return $jcomet._executionJComet(
                funcScope.url,
                funcScope.callbackName,
                funcScope.groupId,
                funcScope.cometId,jargs ) ;
        } ;
        
        // JComet実行結果を取得するメソッドを生成.
        __VAL_GLOVAL__[funcScope.callbackName] = function( resCometId,result ) {
            // 戻り値のコメットIDがセットされている場合は、それを取得.
            if( isNull( resCometId ) == false ) {
                funcScope.cometId = resCometId ;
            }
            // 設定された実行オブジェクトを取得する.
            // 1 : JComet実行メソッド.
            // 2 : 実行から、結果取得までの時間.
            // 3 : JComet戻り値.
            return funcScope.callFunc(
                funcScope.jcometFunc,
                new Date().getTime()-funcScope.time,
                result ) ;
        } ;
        
        // 生成したJCometメソッドを返す.
        return funcScope.jcometFunc ;
    },
    // jcomet実行処理.
    _executionJComet : function(url,callback,groupId,cometId,args) {
        // スクリプトIDを取得.
        var scriptName = "jcmt-"+md5( url )+"-"+this._counter+"-"+new Date().getTime() ;
        this._counter ++ ;
        // url名に整形.
        if( $base.startsWith( url,"http://" ) == false &&
            $base.startsWith( url,"https://" ) == false ) {
            url = "http://" + url ;
        }
        if( $base.endsWith( url,".ms" ) == true ) {
            url = url.substring( 0,url.length()-".ms".length ) ;
        }
        if( $base.endsWith( url,"JComet" ) == false ) {
            url = url + "JComet" ;
        }
        if( $base.endsWith( url,".ms" ) == false ) {
            url = url + ".ms" ;
        }
        // パラメータ引数をJSON形式に変換.
        if( $base.isNull( args ) ) {
            args = [] ;
        }
        // ID追加.
        var params = "jid="+scriptName+"Id" ;
        // JSONP引数.
        if( args.length > 0 ) {
            params += "&jargs="+ encodeURIComponent( $json.encode( args ) ) ;
        }
        // IE以外のアクセスを示す.
        if( isMSIE == false ) {
            params += "&ie=0" ;
        }
        // IEのアクセスを示す.
        else {
            params += "&ie=1" ;
        }
        // グループID、コメットIDを設定.
        params += "&groupId=" + encodeURIComponent( groupId ) ;
        params += "&cometId=" + encodeURIComponent( cometId ) ;
        // コールバックメソッドが存在する場合、その内容をパラメータとしてセット.
        if( $base.useString( callback ) ) {
            var p = callback.indexOf( "(" ) ;
            if( p >= 0 ) {
                callback = callback.substring( 0,p ) ;
            }
            params += "&callback="+encodeURIComponent(callback) ;
        }
        return $jsonpRPC._accessjsonp( url,scriptName+"Id",scriptName,params ) ;
    }
}

