/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.maachang.dbm.MBinary;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmImpl;
import org.maachang.dbm.MDbmTranEnum;
import org.maachang.dbm.MTransaction;
import org.maachang.dbm.engine.MDbmEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDbmTransaction
implements MDbm {
    protected static final int TYPE_PUT = 1;
    protected static final int TYPE_REMOVE = 2;
    private MDbmImpl impl = null;
    private Hashtable<MBinary, MTransaction> man = null;
    private int count = -1;

    private MDbmTransaction() {
    }

    public MDbmTransaction(MDbmImpl impl) {
        this.impl = impl;
        this.man = new Hashtable();
        this.count = 0;
    }

    protected void finalize() throws Exception {
        try {
            this.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public MDbm getParent() {
        return this.impl;
    }

    @Override
    public void close() throws Exception {
        this.commit();
    }

    @Override
    public synchronized void commit() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.man.size() <= 0) {
            return;
        }
        this.check();
        try {
            int len = this.man.size();
            Object[] trans = new MTransaction[len];
            Object[] k = this.man.keySet().toArray();
            int i = 0;
            while (i < len) {
                trans[i] = this.man.get((MBinary)k[i]);
                ++i;
            }
            k = null;
            this.clearMan();
            Arrays.sort(trans);
            i = 0;
            while (i < len) {
                int type = ((MTransaction)trans[i]).getType();
                switch (type) {
                    case 1: {
                        this.impl.put(((MTransaction)trans[i]).getKey().getBinary(), ((MTransaction)trans[i]).getValue());
                        break;
                    }
                    case 2: {
                        this.impl.remove(((MTransaction)trans[i]).getKey().getBinary());
                    }
                }
                trans[i] = null;
                ++i;
            }
        }
        catch (Exception e) {
            this.clearMan();
            throw e;
        }
    }

    @Override
    public synchronized void rollback() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.clearMan();
    }

    @Override
    public synchronized void check() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.man.size() <= 0) {
            return;
        }
        Object[] k = this.man.keySet().toArray();
        int len = k.length;
        int keys = 0;
        int vals = 0;
        int i = 0;
        while (i < len) {
            MTransaction t = this.man.get((MBinary)k[i]);
            if (t.getType() == 1) {
                if (!this.impl.containsKey(t.getKey().getBinary())) {
                    ++keys;
                }
                vals += MDbmEngine.convertLengthBySectorLength(t.getValue().length);
            }
            ++i;
        }
        try {
            this.impl.getEngine().addChecks(keys, vals);
        }
        catch (Exception e) {
            this.clearMan();
            throw e;
        }
    }

    @Override
    public synchronized void put(byte[] key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        MBinary b = new MBinary(key);
        MTransaction t = new MTransaction(this.count, 1, b, value);
        this.man.put(b, t);
        ++this.count;
    }

    @Override
    public synchronized void remove(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        MBinary b = new MBinary(key);
        MTransaction t = this.man.get(b);
        if (t == null) {
            if (!this.impl.containsKey(key)) {
                return;
            }
        } else {
            this.man.remove(b);
            return;
        }
        t = new MTransaction(this.count, 2, b, null);
        this.man.put(b, t);
        ++this.count;
    }

    @Override
    public synchronized byte[] get(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        MBinary b = new MBinary(key);
        MTransaction t = this.man.get(b);
        if (t == null) {
            return this.impl.get(key);
        }
        if (t.getType() == 2) {
            return null;
        }
        return t.getValue();
    }

    @Override
    public synchronized boolean containsKey(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        MBinary b = new MBinary(key);
        MTransaction t = this.man.get(b);
        if (t == null) {
            return this.impl.containsKey(key);
        }
        return t.getType() != 2;
    }

    @Override
    public Enumeration<byte[]> elements() {
        if (!this.isUse()) {
            return null;
        }
        return new MDbmTranEnum(this.impl.getEngine(), this.man);
    }

    @Override
    public long sequenceId(int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.impl.sequenceId(no);
    }

    @Override
    public synchronized int size() {
        if (!this.isUse()) {
            return -1;
        }
        int pls = 0;
        int len = this.man.size();
        if (len > 0) {
            Object[] k = this.man.keySet().toArray();
            int i = 0;
            while (i < len) {
                switch (this.man.get((MBinary)k[i]).getType()) {
                    case 1: {
                        ++pls;
                        break;
                    }
                    case 2: {
                        --pls;
                    }
                }
                ++i;
            }
        }
        return this.impl.size() + pls;
    }

    @Override
    public synchronized String getDirectory() {
        if (!this.isUse()) {
            return null;
        }
        return this.impl.getDirectory();
    }

    @Override
    public synchronized boolean isUse() {
        if (this.impl == null || this.man == null) {
            return false;
        }
        return this.impl.isUse();
    }

    @Override
    public synchronized boolean isTransaction() {
        return true;
    }

    private void clearMan() {
        if (this.man != null) {
            this.man.clear();
        }
        this.count = 0;
    }
}

