/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.maachang.connector.ConnectorSession;

public class ConnectorManager {
    protected static final int MIN_LENGTH = 5;
    protected static final int MAX_LENGTH = 500;
    private ArrayList<ConnectorSession> man = null;
    private ServerSocket server = null;

    private ConnectorManager() {
    }

    public ConnectorManager(InetAddress addr, int port, int backlog) throws Exception {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30fc\u30c8\u756a\u53f7\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (backlog <= 5) {
            backlog = 5;
        } else if (backlog > 500) {
            backlog = 500;
        }
        ServerSocket server = new ServerSocket();
        server.setReuseAddress(true);
        server.setSoTimeout(5000);
        if (addr == null) {
            server.bind(new InetSocketAddress(port), backlog);
        } else {
            server.bind(new InetSocketAddress(addr, port), backlog);
        }
        this.server = server;
        this.man = new ArrayList();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.man != null) {
            int len = this.man.size();
            int i = 0;
            while (i < len) {
                try {
                    this.man.remove(0).destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server = null;
        this.man = null;
    }

    public synchronized void append(byte[] headerBinary, Socket s) throws Exception {
        if (this.isClosed()) {
            if (s != null && !s.isClosed()) {
                try {
                    s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        if (s == null || s.isClosed()) {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        this.man.add(new ConnectorSession(headerBinary, s));
    }

    public synchronized void append(ConnectorSession s) {
        if (this.isClosed()) {
            return;
        }
        if (s != null && !s.isClosed()) {
            this.man.add(s);
        }
    }

    public synchronized ConnectorSession get(int no) {
        if (this.isClosed()) {
            return null;
        }
        ConnectorSession s = null;
        try {
            s = this.man.remove(no);
        }
        catch (Exception e) {
            s = null;
        }
        if (s != null && s.isClosed()) {
            try {
                s.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            s = null;
        }
        return s;
    }

    public synchronized void remove(int no) {
        if (this.isClosed()) {
            return;
        }
        ConnectorSession s = null;
        try {
            s = this.man.remove(no);
        }
        catch (Exception e) {
            s = null;
        }
        if (s != null && !s.isClosed()) {
            s.destroy();
        }
    }

    public synchronized ServerSocket getServerSocket() {
        if (this.isClosed()) {
            return null;
        }
        return this.server;
    }

    public synchronized int size() {
        if (this.isClosed()) {
            return -1;
        }
        return this.man.size();
    }

    public synchronized boolean isClosed() {
        boolean ret = false;
        try {
            if (this.man == null || this.server == null || !this.server.isBound() || this.server.isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

