/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import org.maachang.connector.ConnectorAcceptThread;
import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorManager;
import org.maachang.connector.ConnectorPoolThread;
import org.maachang.connector.ConnectorQueue;
import org.maachang.connector.ConnectorReceiveThread;

public class ConnectorService {
    private ConnectorAcceptThread accept = null;
    private ConnectorReceiveThread receive = null;
    private ConnectorPoolThread[] pool = null;

    private ConnectorService() {
    }

    public ConnectorService(byte[] headerBinary, ConnectorCallback callback, ConnectorManager manager, int poolLen) throws Exception {
        if (callback == null || manager.isClosed() || poolLen <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ConnectorQueue rq = new ConnectorQueue();
        ConnectorAcceptThread ac = new ConnectorAcceptThread(headerBinary, manager);
        ConnectorReceiveThread rc = new ConnectorReceiveThread(manager, rq);
        ConnectorPoolThread[] pt = new ConnectorPoolThread[poolLen];
        int i = 0;
        while (i < poolLen) {
            pt[i] = new ConnectorPoolThread(headerBinary, manager, callback, rq);
            ++i;
        }
        this.accept = ac;
        this.receive = rc;
        this.pool = pt;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.pool != null) {
            int len = this.pool.length;
            int i = 0;
            while (i < len) {
                if (this.pool[i] != null) {
                    this.pool[i].destroy();
                }
                this.pool[i] = null;
                ++i;
            }
            this.pool = null;
        }
        if (this.receive != null) {
            this.receive.destroy();
            this.receive = null;
        }
        if (this.accept != null) {
            this.accept.destroy();
            this.accept = null;
        }
    }
}

