/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.math.BigDecimal;

public class ConvertParam {
    public static final String CHARSET = "UTF8";
    private static final char ENDCHAR = '\u0000';
    private static final int BOOLEAN_TRUE_CD = 1;
    private static final int BOOLEAN_FALSE_CD = 0;
    public static final int LENGTH_BOOLEAN = 1;
    public static final int LENGTH_BYTE = 1;
    public static final int LENGTH_CHAR = 2;
    public static final int LENGTH_SHORT = 2;
    public static final int LENGTH_INT = 4;
    public static final int LENGTH_LONG = 8;

    private ConvertParam() {
    }

    public static final short swap(short value) {
        return (short)((value & 0xFF) << 8 | (value & 0xFF00) >> 8);
    }

    public static final char swap(char value) {
        return (char)((value & 0xFF) << 8 | (value & 0xFF00) >> 8);
    }

    public static final int swap(int value) {
        return (value & 0xFF) << 24 | (value & 0xFF00) << 8 | (value & 0xFF0000) >> 8 | (value & 0xFF000000) >> 24;
    }

    public static final long swap(long value) {
        return (value & 0xFFL) << 56 | (value & 0xFF00L) << 40 | (value & 0xFF0000L) << 24 | (value & 0xFF000000L) << 8 | (value & 0xFF00000000L) >> 8 | (value & 0xFF0000000000L) >> 24 | (value & 0xFF000000000000L) >> 40 | (value & 0xFF00000000000000L) >> 56;
    }

    public static final byte[] convertBoolean(boolean value) {
        byte[] ret = null;
        ret = new byte[]{(byte)(value ? 1 : 0)};
        return ret;
    }

    public static final void convertBoolean(byte[] out, int offset, boolean value) {
        out[offset] = (byte)(value ? 1 : 0);
    }

    public static final boolean convertBoolean(int off, byte[] binary) throws Exception {
        return (binary[off] & 0xFF) == 1;
    }

    public static final byte[] convertByte(byte value) {
        byte[] ret = null;
        ret = new byte[]{value};
        return ret;
    }

    public static final void convertByte(byte[] out, int offset, byte value) {
        out[offset] = value;
    }

    public static final byte convertByte(int off, byte[] binary) throws Exception {
        return binary[off];
    }

    public static final byte[] convertChar(char value) {
        byte[] ret = null;
        ret = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        return ret;
    }

    public static final void convertChar(byte[] out, int offset, char value) {
        out[offset] = (byte)(value & 0xFF);
        out[offset + 1] = (byte)((value & 0xFF00) >> 8);
    }

    public static final char convertChar(int off, byte[] binary) throws Exception {
        return (char)(binary[off] & 0xFF | (binary[off + 1] & 0xFF) << 8);
    }

    public static final byte[] convertShort(short value) {
        byte[] ret = null;
        ret = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        return ret;
    }

    public static final void convertShort(byte[] out, int offset, short value) {
        out[offset] = (byte)(value & 0xFF);
        out[offset + 1] = (byte)((value & 0xFF00) >> 8);
    }

    public static final short convertShort(int off, byte[] binary) throws Exception {
        return (short)(binary[off] & 0xFF | (binary[off + 1] & 0xFF) << 8);
    }

    public static final byte[] convertInt(int value) {
        byte[] ret = null;
        ret = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF000000) >> 24)};
        return ret;
    }

    public static final void convertInt(byte[] out, int offset, int value) {
        out[offset] = (byte)(value & 0xFF);
        out[offset + 1] = (byte)((value & 0xFF00) >> 8);
        out[offset + 2] = (byte)((value & 0xFF0000) >> 16);
        out[offset + 3] = (byte)((value & 0xFF000000) >> 24);
    }

    public static final int convertInt(int off, byte[] binary) throws Exception {
        return binary[off] & 0xFF | (binary[off + 1] & 0xFF) << 8 | (binary[off + 2] & 0xFF) << 16 | (binary[off + 3] & 0xFF) << 24;
    }

    public static final byte[] convertLong(long value) {
        byte[] ret = null;
        ret = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24), (byte)((value & 0xFF00000000L) >> 32), (byte)((value & 0xFF0000000000L) >> 40), (byte)((value & 0xFF000000000000L) >> 48), (byte)((value & 0xFF00000000000000L) >> 56)};
        return ret;
    }

    public static final void convertLong(byte[] out, int offset, long value) {
        out[offset] = (byte)(value & 0xFFL);
        out[offset + 1] = (byte)((value & 0xFF00L) >> 8);
        out[offset + 2] = (byte)((value & 0xFF0000L) >> 16);
        out[offset + 3] = (byte)((value & 0xFF000000L) >> 24);
        out[offset + 4] = (byte)((value & 0xFF00000000L) >> 32);
        out[offset + 5] = (byte)((value & 0xFF0000000000L) >> 40);
        out[offset + 6] = (byte)((value & 0xFF000000000000L) >> 48);
        out[offset + 7] = (byte)((value & 0xFF00000000000000L) >> 56);
    }

    public static final long convertLong(int off, byte[] binary) throws Exception {
        return (long)binary[off] & 0xFFL | ((long)binary[off + 1] & 0xFFL) << 8 | ((long)binary[off + 2] & 0xFFL) << 16 | ((long)binary[off + 3] & 0xFFL) << 24 | ((long)binary[off + 4] & 0xFFL) << 32 | ((long)binary[off + 5] & 0xFFL) << 40 | ((long)binary[off + 6] & 0xFFL) << 48 | ((long)binary[off + 7] & 0xFFL) << 56;
    }

    public static final byte[] convertFloat(float value) {
        byte[] ret = null;
        String str = null;
        str = String.valueOf(value);
        int len = str.length();
        len = (len + 1) / 2 + 2;
        ret = new byte[len];
        ConvertParam.convertFloatStringByBinary(ret, 0, str);
        str = null;
        return ret;
    }

    public static final int convertFloat(byte[] out, int offset, float value) {
        return ConvertParam.convertFloatStringByBinary(out, offset, String.valueOf(value));
    }

    public static final float convertFloat(int off, byte[] binary) throws Exception {
        return Float.parseFloat(ConvertParam.convertFloatBinaryByString(off, binary));
    }

    public static final byte[] convertDouble(double value) {
        byte[] ret = null;
        String str = null;
        str = String.valueOf(value);
        int len = str.length();
        len = (len + 1) / 2 + 2;
        ret = new byte[len];
        ConvertParam.convertFloatStringByBinary(ret, 0, str);
        str = null;
        return ret;
    }

    public static final int convertDouble(byte[] out, int offset, double value) {
        return ConvertParam.convertFloatStringByBinary(out, offset, String.valueOf(value));
    }

    public static final double convertDouble(int off, byte[] binary) throws Exception {
        return Double.parseDouble(ConvertParam.convertFloatBinaryByString(off, binary));
    }

    public static final byte[] convertDecimal(BigDecimal value) {
        byte[] ret = null;
        String str = null;
        str = value.toString();
        int len = str.length();
        len = (len + 1) / 2 + 2;
        ret = new byte[len];
        ConvertParam.convertFloatStringByBinary(ret, 0, str);
        str = null;
        return ret;
    }

    public static final int convertDecimal(byte[] out, int offset, BigDecimal value) {
        return ConvertParam.convertFloatStringByBinary(out, offset, value.toString());
    }

    public static final BigDecimal convertDecimal(int off, byte[] binary) throws Exception {
        return new BigDecimal(ConvertParam.convertFloatBinaryByString(off, binary));
    }

    public static final byte[] convertChars(char[] value) {
        byte[] ret = null;
        int len = value.length;
        ret = new byte[len * 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            ret[j] = (byte)(value[i] & 0xFF);
            ret[j + 1] = (byte)((value[i] & 0xFF00) >> 8);
            ++i;
            j += 2;
        }
        return ret;
    }

    public static final void convertChars(byte[] out, int offset, char[] value) {
        int len = value.length;
        int i = 0;
        int j = offset;
        while (i < len) {
            out[j] = (byte)(value[i] & 0xFF);
            out[j + 1] = (byte)((value[i] & 0xFF00) >> 8);
            ++i;
            j += 2;
        }
    }

    public static final char[] convertChars(int off, int length, byte[] binary) throws Exception {
        char[] ret = null;
        if (binary == null || length <= 0 || (length & 1) == 1) {
            if ((length & 1) == 1) {
                throw new IllegalArgumentException("length\u9577\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ret = new char[length / 2];
        int len = length + off;
        int i = off;
        int j = 0;
        while (i < len) {
            ret[j] = (char)(binary[i] & 0xFF | (binary[i + 1] & 0xFF) << 8);
            i += 2;
            ++j;
        }
        return ret;
    }

    public static final byte[] convertString(String value) throws Exception {
        return value.getBytes(CHARSET);
    }

    public static final int convertString(byte[] out, int offset, String value) throws Exception {
        byte[] tmp = null;
        tmp = value.getBytes(CHARSET);
        int ret = tmp.length;
        System.arraycopy(tmp, 0, out, offset, ret);
        return ret;
    }

    public static final String convertString(int off, int length, byte[] binary) throws Exception {
        byte[] bin = null;
        String ret = null;
        if (binary == null || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        bin = new byte[length];
        System.arraycopy(binary, off, bin, 0, length);
        ret = new String(bin, CHARSET);
        return ret;
    }

    private static final int convertFloatStringByBinary(byte[] out, int off, String data) {
        int len = data.length();
        int ret = (len + 1) / 2;
        out[off] = (byte)(ret & 0xFF);
        out[off + 1] = (byte)((ret & 0xFF00) >> 8);
        int i = 0;
        int j = off + 2;
        while (i < len) {
            byte dat = ConvertParam.cnvCharByNumBin(data.charAt(i));
            if ((i & 1) == 0) {
                out[j] = (byte)(dat & 0xF);
            } else {
                int n = j++;
                out[n] = (byte)(out[n] | (byte)((dat & 0xF) << 4));
            }
            ++i;
        }
        return ret;
    }

    public static final String convertFloatBinaryByString(int off, byte[] binary) throws Exception {
        StringBuffer buf = null;
        String ret = null;
        if (binary == null || binary.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        buf = new StringBuffer();
        int len = binary[off] & 0xFF | (binary[off + 1] & 0xFF) << 8;
        int i = 0;
        int j = off + 2;
        while (i < len) {
            char dat = ConvertParam.cnvNumBinByChar((byte)(binary[j] & 0xF));
            if (dat == '\u0000') break;
            buf.append(dat);
            dat = ConvertParam.cnvNumBinByChar((byte)((binary[j] & 0xF0) >> 4));
            if (dat == '\u0000') break;
            buf.append(dat);
            ++i;
            ++j;
        }
        ret = buf.toString();
        return ret;
    }

    private static final byte cnvCharByNumBin(char cd) {
        byte ret;
        switch (cd) {
            case '0': {
                ret = 1;
                break;
            }
            case '1': {
                ret = 2;
                break;
            }
            case '2': {
                ret = 3;
                break;
            }
            case '3': {
                ret = 4;
                break;
            }
            case '4': {
                ret = 5;
                break;
            }
            case '5': {
                ret = 6;
                break;
            }
            case '6': {
                ret = 7;
                break;
            }
            case '7': {
                ret = 8;
                break;
            }
            case '8': {
                ret = 9;
                break;
            }
            case '9': {
                ret = 10;
                break;
            }
            case '+': {
                ret = 11;
                break;
            }
            case '-': {
                ret = 12;
                break;
            }
            case '.': {
                ret = 13;
                break;
            }
            default: {
                ret = 15;
            }
        }
        return ret;
    }

    private static final char cnvNumBinByChar(byte cd) {
        char ret;
        switch (cd) {
            case 0: {
                ret = '\u0000';
                break;
            }
            case 1: {
                ret = '0';
                break;
            }
            case 2: {
                ret = '1';
                break;
            }
            case 3: {
                ret = '2';
                break;
            }
            case 4: {
                ret = '3';
                break;
            }
            case 5: {
                ret = '4';
                break;
            }
            case 6: {
                ret = '5';
                break;
            }
            case 7: {
                ret = '6';
                break;
            }
            case 8: {
                ret = '7';
                break;
            }
            case 9: {
                ret = '8';
                break;
            }
            case 10: {
                ret = '9';
                break;
            }
            case 11: {
                ret = '+';
                break;
            }
            case 12: {
                ret = '-';
                break;
            }
            case 13: {
                ret = '.';
                break;
            }
            default: {
                ret = '?';
            }
        }
        return ret;
    }
}

