package org.maachang.dbm ;

import org.maachang.util.FileUtil;

/**
 * MaachangDbm用プロジェクト雛型を作成.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
class MDbmProjectProcess {
    
    /**
     * コンストラクタ.
     */
    private MDbmProjectProcess() {
        
    }
    
    /**
     * main.
     */
    public static final void main( String[] args ) throws Exception {
        if( args.length <= 0 ) {
            System.out.println( "引数が足りません" ) ;
            return ;
        }
        else if( FileUtil.isDirExists( args[0] ) == false ) {
            System.out.println( "ディレクトリ[" +args[0]+ "]は存在しません" ) ;
            return ;
        }
        mkdirLog() ;
        mkdirConfig() ;
        copyByConfig( args[0] ) ;
    }
    
    /**
     * コンフィグファイル内容をコピー.
     */
    private static final void copyByConfig( String dir )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/conf" ) ;
        String destDir = FileUtil.getFullPath( "./conf" ) ;
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                byte[] bin = FileUtil.getFile( dir+FileUtil.FILE_SPACE+lst[ i ] ) ;
                if( bin != null ) {
                    FileUtil.setFile( destDir+FileUtil.FILE_SPACE+lst[ i ],bin ) ;
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
                bin = null ;
            }
        }
    }
    
    /**
     * コンフィグディレクトリを生成.
     */
    private static final void mkdirConfig()
        throws Exception {
        if( FileUtil.isDirExists( "./conf" ) == false ) {
            FileUtil.mkdirs( "./conf" ) ;
        }
    }
    
    /**
     * ログディレクトリを生成.
     */
    private static final void mkdirLog()
        throws Exception {
        if( FileUtil.isDirExists( "./log" ) == false ) {
            FileUtil.mkdirs( "./log" ) ;
        }
    }
}
