package org.maachang.dbm.engine ;

import java.util.HashSet;

/**
 * 指定キーでロック処理.
 * 
 * @version 2008/04/16
 * @author masahito suzuki
 * @since MaachangDBM 1.09
 */
class KeyLock {
    
    /**
     * ロックスリープ時間.
     */
    private static final long SLEEP_TIME = 5L ;
    
    /**
     * ロック名群.
     */
    private HashSet<byte[]> manager = null ;
    
    /**
     * コンストラクタ.
     */
    public KeyLock() {
        manager = new HashSet<byte[]>() ;
    }
    
    /**
     * 指定名でロック.
     * @param name 対象の名前を設定します.
     * @exceptino InterruptedException スレッド割り込み例外.
     */
    public void lock( byte[] name ) throws InterruptedException {
        if( name == null || name.length <= 0 ) {
            return ;
        }
        for( ;; ) {
            synchronized( this ) {
                if( manager.contains( name ) == false ) {
                    manager.add( name ) ;
                    break ;
                }
            }
            Thread.sleep( SLEEP_TIME ) ;
        }
    }
    
    /**
     * 指定名でアンロック.
     * @param name 対象の名前を設定します.
     */
    public void unlock( byte[] name ) {
        if( name == null || name.length <= 0 ) {
            return ;
        }
        synchronized( this ) {
            manager.remove( name ) ;
        }
    }
}
