package org.maachang.dbm.service ;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.maachang.util.ConvertParam;

/**
 * PoolThread.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class PoolThread extends Thread {
    
    /**
     * 受信可能最大データ長.
     */
    private static final int MAX_BYTE = 32 * 0x00100000 ;
    
    private volatile boolean stopFlag = true ;
    private SocketManager man = null ;
    private ReceiveQueue queue = null ;
    
    private PoolThread() {
        
    }
    
    public PoolThread( SocketManager man,ReceiveQueue queue )
        throws Exception {
        if( man == null || man.isClosed() == true || queue == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.man = man ;
        this.queue = queue ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    private static final long WAIT = 30L ;
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            DbmSession s = null ;
            try {
                s = this.queue.getQueue() ;
                if( s == null ) {
                    Thread.sleep( WAIT ) ;
                    continue ;
                }
                else if( s.isClosed() == true ) {
                    continue ;
                }
                else {
                    byte[] b = receive( s ) ;
                    if( b != null ) {
                        ExecutionMDbm.execution( b,s ) ;
                        s.successHeartBeat() ;
                    }
                    b = null ;
                }
            } catch( InterruptedException ie ) {
                endFlag = true ;
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
                if( s != null ) {
                    s.destroy() ;
                }
                s = null ;
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            } finally {
                if( s != null && s.isClosed() == false ) {
                    man.append( s ) ;
                }
            }
        }
        this.man = null ;
        this.queue = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
    private byte[] receive( DbmSession s ) throws Exception {
        int len = -1 ;
        ByteArrayOutputStream bs = new ByteArrayOutputStream() ;
        InputStream in = s.inputStream() ;
        try {
            if( s.isClosed() == true ) {
                bs.close() ;
                bs = null ;
                return null ;
            }
            byte[] ret = null ;
            int cnt = 0 ;
            for( ;; ) {
                int n = in.read() ;
                if( n <= -1 ) {
                    break ;
                }
                bs.write( n ) ;
                cnt ++ ;
                if( len <= -1 ) {
                    if( len <= -2 ) {
                        ret = null ;
                        break ;
                    }
                    if( cnt >= ProtocolDef.OFFSET ) {
                        byte[] bin = bs.toByteArray() ;
                        len = ConvertParam.convertInt( 0,bin ) ;
                        if( len == 0 ) {
                            bs.close() ;
                            bs = null ;
                            // heartbeat受け付け処理.
                            s.successHeartBeat() ;// heartBeat受信完了.
                            if( in.available() > 0 ) {
                                // 次のデータが存在する場合は、続行.
                                bs = new ByteArrayOutputStream() ;
                                len = -1 ;
                            }
                            else {
                                return null ;
                            }
                        }
                        // 不正な受信サイズ.
                        else if( len <= -1 || len >= MAX_BYTE ) {
                            s.destroy() ;
                            s = null ;
                            bs.close() ;
                            bs = null ;
                            return null ;
                        }
                    }
                }
                if( len > 0 ) {
                    if( cnt >= len ) {
                        ret = bs.toByteArray() ;
                        break ;
                    }
                }
            }
            bs.close() ;
            bs = null ;
            return ret ;
        } catch( Exception e ) {
            if( s != null ) {
                s.destroy() ;
            }
            return null ;
        } finally {
            if( bs != null ) {
                try {
                    bs.close() ;
                } catch( Exception e ) {
                }
            }
            bs = null ;
        }
    }
}

