package org.maachang.dbm.service ;

import java.util.LinkedList;

/**
 * ReceiveQueue.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class ReceiveQueue {
    private LinkedList<DbmSession> queue = null ;
    
    public ReceiveQueue() {
        queue = new LinkedList<DbmSession>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( DbmSession s ) {
        if( queue == null || s == null || s.isClosed() == true ) {
            return ;
        }
        queue.add( s ) ;
    }
    
    public synchronized DbmSession getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
}
