package org.maachang.dbm.service.client ;


/**
 * ClientHeartBeatThread.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class ClientHeartBeatThread extends Thread {
    
    private volatile boolean stopFlag = true ;
    private ClientConnectManager man = null ;
    private Object sync = null ;
    
    private ClientHeartBeatThread() {
        
    }
    
    public ClientHeartBeatThread( Object sync,ClientConnectManager man )
        throws Exception {
        if( sync == null || man == null || man.isUse() == false ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.man = man ;
        this.sync = sync ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            try {
                Thread.sleep( 5L ) ;
                int len = man.size() ;
                for( int i = len-1 ; i >= 0 ; i -- ) {
                    ClientSession s = null ;
                    boolean rcvFlag = false ;
                    try {
                        synchronized( sync ) {
                            s = man.get( i ) ;
                            if( s == null || s.isUse() == false ) {
                                man.remove( i ) ;
                                continue ;
                            }
                            rcvFlag = ( s.isReceiveMethod() == false && s.isReceive() == true ) ;
                            if( rcvFlag == true ) {
                                // 受信処理開始.
                                s.startReceive() ;
                            }
                        }
                        if( rcvFlag == true ) {
                            ResultClientQueue q = s.getQueue() ;
                            byte[] b = s.receive() ;
                            if( b != null ) {
                                q.putQueue( b ) ;
                            }
                        }
                    } catch( Exception ee ) {
                        if( s != null ) {
                            s.destroy() ;
                        }
                    } finally {
                        if( rcvFlag == true ) {
                            // 受信処理終了.
                            try {
                                s.exitReceive() ;
                            } catch( Exception ee ) {
                            }
                        }
                    }
                }
            } catch( InterruptedException ie ) {
            } catch ( NullPointerException ne ) {
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        this.man = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
}

