package org.maachang.dbm.service.client ;

import java.net.InetAddress;
import java.util.Enumeration;

import org.maachang.dbm.MDbm;

/**
 * MDbmConnection.
 * 
 * @version 2008/01/20
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class MDbmConnection implements MDbm {
    
    /**
     * コネクションオブジェクト.
     */
    private MDbmClientConnection conn = null ;
    
    /**
     * コンストラクタ.
     */
    private MDbmConnection() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR>
     * @param sync 同期用オブジェクトを設定します.
     * @param addr 対象のアドレスを設定します.
     * @param port 対象のポート番号を設定します.
     * @exception Exception 例外.
     */
    protected MDbmConnection( Object sync,InetAddress addr,int port ) throws Exception {
        this.conn = new MDbmClientConnection( sync,addr,port ) ;
    }
    
    /**
     * MDbmオブジェクトを取得.
     * <BR>
     * @return MDbm オブジェクトが返されます.
     */
    public MDbm getParent() {
        return null ;
    }
    
    /**
     * クリアー処理.
     * <BR>
     * @exception Exception 例外.
     */
    public void close() throws Exception {
        conn.destroy() ;
    }
    
    /**
     * コミット処理.
     * <BR>
     * @exception Exception 例外.
     */
    public void commit() throws Exception {
        conn.commit() ;
    }
    
    /**
     * ロールバック処理.
     * <BR>
     * @exception Exception 例外.
     */
    public void rollback() throws Exception {
        conn.rollback() ;
    }
    
    /**
     * データ登録が可能かチェック.
     * <BR>
     * @exception Exception 例外.
     */
    public void check() throws Exception {
        conn.check() ;
    }
    
    /**
     * 情報を設定.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @param value 対象の情報を設定します.
     * @exception Exception 例外.
     */
    public void put( byte[] key,byte[] value ) throws Exception {
        conn.put( key,value ) ;
    }
    
    /**
     * 情報を削除.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @exception Exception 例外.
     */
    public void remove( byte[] key ) throws Exception {
        conn.remove( key ) ;
    }
    
    /**
     * 情報を取得.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @return byte[] 対象の情報が返されます.
     * @exception Exception 例外.
     */
    public byte[] get( byte[] key ) throws Exception {
        return conn.get( key ) ;
    }
    
    /**
     * 指定キーが存在するかチェック.
     * <BR>
     * @param key チェック対象のキー内容を設定します.
     * @return boolean [true]の場合、情報が存在します.
     * @exception Exception 例外.
     */
    public boolean containsKey( byte[] key) throws Exception {
        return conn.containsKey( key ) ;
    }
    
    /**
     * キー内容を列挙.
     * <BR><BR>
     * @return  Enumeration<byte[]> 列挙オブジェクトが返されます.<BR>
     *                              [null]が返された場合、オブジェクトは既に破棄されています.
     */
    public Enumeration<byte[]> elements() {
        Enumeration<byte[]> ret = null ;
        try {
            ret = new MDbmEnumConnection( conn ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    
    /**
     * 新しいシーケンスIDを取得.
     * <BR><BR>
     * 新しいシーケンスIDを取得します.<BR>
     * このメソッドはトランザクションに対応しません.
     * <BR>
     * @param no シーケンスNoを設定します.<BR>
     *           [0-63]まで利用可能です.
     * @return long 新しいシーケンスIDが返されます.
     * @exception Exception 例外.
     */
    public long sequenceId( int no ) throws Exception {
        return conn.sequenceId( no ) ;
    }
    
    /**
     * 格納情報数を取得.
     * <BR>
     * @return int 格納情報数が返されます.<BR>
     *             [-1]が返された場合、オブジェクトは既に破棄されています.
     */
    public int size() {
        int ret = -1 ;
        try {
            ret = conn.size() ;
        } catch( Exception e ) {
            ret = -1 ;
        }
        return ret ;
    }
    
    /**
     * MaachangDbm展開ディレクトリを取得.
     * <BR>
     * @return String MaachangDbm展開ディレクトリ名が返されます.
     */
    public String getDirectory() {
        String ret = null ;
        try {
            ret = conn.getDirectory() ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    
    /**
     * このオブジェクトが有効かチェック.
     * <BR>
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() {
        if( conn == null ) {
            return false ;
        }
        return conn.isUse() ;
    }
    
    /**
     * このオブジェクトがトランザクション対応かチェック.
     * <BR>
     * @return boolean [true]の場合、トランザクションに対応しています.
     */
    public boolean isTransaction() {
        return true ;
    }
    
    /**
     * クライアントコネクションを取得.
     * <BR>
     * @return MDbmClientConnection クライアントコネクションが返されます.
     */
    public MDbmClientConnection clientConnection() {
        return conn ;
    }
}

