package org.maachang.dbm.service.client ;

import java.util.LinkedList;

/**
 * ResultClientQueue.
 * 
 * @version 2008/01/20
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class ResultClientQueue {
    private LinkedList<byte[]> queue = null ;
    
    public ResultClientQueue() {
        queue = new LinkedList<byte[]>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void putQueue( byte[] result ) {
        if( queue == null || result == null || result.length <= 0 ) {
            return ;
        }
        queue.add( result ) ;
    }
    
    public synchronized byte[] getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized boolean isUse() {
        return ( queue == null ) ? false : true ;
    }
}
