/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.maachang.util.ConvertParam;

class FlagMapFile {
    protected static final int ETC_MASK = 31;
    protected static final int FSS_MASK = -32;
    protected static final int RIGHT_SHIFT = 5;
    private static final int OFFSET = 12;
    private MappedByteBuffer map = null;
    private final byte[] tmp = new byte[4];

    private FlagMapFile() {
    }

    public FlagMapFile(RandomAccessFile fp, int startPos, int size) throws Exception {
        this(false, fp, startPos, size);
    }

    public FlagMapFile(boolean mode, RandomAccessFile fp, int startPos, int size) throws Exception {
        if (fp == null || startPos <= -1 || (long)startPos >= fp.length() || size <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int max = ((size & 0xFFFFFFE0) >> 5) + ((size & 0x1F) != 0 ? 1 : 0);
        int maxPos = max * 32;
        int all = max * 4 + 12;
        FileChannel channel = fp.getChannel();
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, startPos, all);
        if (mode) {
            byte[] b = new byte[all];
            Arrays.fill(b, (byte)0);
            map.put(b);
        }
        this.map = map;
        this.mfMaxSize(maxPos);
        this.mfMaxArray(max);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public synchronized void clear() {
        if (this.map != null) {
            try {
                this.map.force();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.map = null;
    }

    public synchronized void flush() throws Exception {
        if (this.map != null) {
            this.map.force();
        }
    }

    public synchronized void setPos(int pos) throws Exception {
        int maxPos = this.mfMaxSize();
        if (pos < 0 || pos >= maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int innerPos = pos & 0x1F;
        int thisPos = (pos & 0xFFFFFFE0) >> 5;
        int target = this.mfArray(thisPos);
        if ((1 << innerPos & target) != 0) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bON\u3067\u3059");
        }
        target = 1 << innerPos | target;
        this.mfArray(thisPos, target);
        this.mfSize(this.mfSize() + 1);
    }

    public synchronized void removePos(int pos) throws Exception {
        int maxPos = this.mfMaxSize();
        if (pos < 0 || pos >= maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int innerPos = pos & 0x1F;
        int thisPos = (pos & 0xFFFFFFE0) >> 5;
        int target = this.mfArray(thisPos);
        if ((1 << innerPos & target) == 0) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bOFF\u3067\u3059");
        }
        target = ~(1 << innerPos) & target;
        this.mfArray(thisPos, target);
        this.mfSize(this.mfSize() - 1);
    }

    public synchronized boolean getPos(int pos) throws Exception {
        int maxPos = this.mfMaxSize();
        if (pos < 0 || pos >= maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3[" + pos + "]\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.targetPos(pos);
    }

    private boolean targetPos(int pos) throws Exception {
        return (1 << (pos & 0x1F) & this.mfArray((pos & 0xFFFFFFE0) >> 5)) != 0;
    }

    private boolean targetPos(int pos, int one) throws Exception {
        return (1 << (pos & 0x1F) & one) != 0;
    }

    public synchronized int useNextPos(int pos) throws Exception {
        int maxPos = this.mfMaxSize();
        if (pos < -1 || pos >= maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int one = 0;
        if ((++pos & 0x1F) != 0) {
            one = this.mfArray((pos & 0xFFFFFFE0) >> 5);
        }
        while (pos < maxPos) {
            if ((pos & 0x1F) == 0 && (one = this.mfArray((pos & 0xFFFFFFE0) >> 5)) == 0) {
                pos += 32;
                continue;
            }
            if (this.targetPos(pos, one)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public synchronized int usePos(int pos) throws Exception {
        if (pos < 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = this.mfMaxArray();
        int i = (pos & 0xFFFFFFE0) >> 5;
        while (i < len) {
            int target = this.mfArray(i);
            if (target != -1) {
                int j = 0;
                while (j < 32) {
                    if ((target & 1 << j) == 0) {
                        return i * 32 + j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    public synchronized int usePosBySet(int pos) throws Exception {
        int u = this.usePos(pos);
        if (u == -1) {
            return -1;
        }
        this.setPos(u);
        return u;
    }

    public synchronized int size() {
        int ret = -1;
        try {
            ret = this.mfSize();
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public synchronized int maxSize() {
        int ret = -1;
        try {
            ret = this.mfMaxSize();
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    private int mfMaxSize() throws Exception {
        this.map.position(0);
        byte[] b = this.tmp;
        this.map.get(b);
        return ConvertParam.convertInt((int)0, (byte[])b);
    }

    private void mfMaxSize(int n) throws Exception {
        this.map.position(0);
        this.map.put(ConvertParam.convertInt((int)n));
    }

    private int mfSize() throws Exception {
        this.map.position(4);
        byte[] b = this.tmp;
        this.map.get(b);
        return ConvertParam.convertInt((int)0, (byte[])b);
    }

    private void mfSize(int n) throws Exception {
        this.map.position(4);
        this.map.put(ConvertParam.convertInt((int)n));
    }

    private int mfMaxArray() throws Exception {
        this.map.position(8);
        byte[] b = this.tmp;
        this.map.get(b);
        return ConvertParam.convertInt((int)0, (byte[])b);
    }

    private void mfMaxArray(int n) throws Exception {
        this.map.position(8);
        this.map.put(ConvertParam.convertInt((int)n));
    }

    private int mfArray(int no) throws Exception {
        this.map.position(12 + no * 4);
        byte[] b = this.tmp;
        this.map.get(b);
        return ConvertParam.convertInt((int)0, (byte[])b);
    }

    private void mfArray(int no, int n) throws Exception {
        this.map.position(12 + no * 4);
        this.map.put(ConvertParam.convertInt((int)n));
    }
}

