/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableUtil {
    private SerializableUtil() {
    }

    public static final byte[] toBinary(Serializable value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        ObjectOutputStream o = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            o = new ObjectOutputStream(b);
            o.writeObject(value);
            o.flush();
            ret = b.toByteArray();
        }
        finally {
            try {
                o.close();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static final Serializable toObject(byte[] bin) throws Exception {
        if (bin == null || bin.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ObjectInputStream in = null;
        Serializable ret = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bin));
            ret = (Serializable)in.readObject();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            in = null;
        }
        return ret;
    }
}

