/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.comet.down.ShutdownServer;
import org.maachang.comet.httpd.HttpdVersionDef;
import org.maachang.comet.httpd.engine.StartupHttpdEngine;
import org.maachang.comet.httpd.engine.script.ExecutionStartup;
import org.maachang.manager.GlobalManager;
import org.maachang.shutdown.ShutdownCallback;
import org.maachang.shutdown.ShutdownHook;
import org.maachang.shutdown.WaitShutdown;

public class Startup {
    private static final Log LOG = LogFactory.getLog(Startup.class);

    private Startup() {
    }

    public static final void main(String[] args) throws Exception {
        new Startup().execution(args);
    }

    private void execution(String[] args) throws Exception {
        String path = ".";
        long tm = System.currentTimeMillis();
        try {
            LOG.info((Object)"*** maachang comet - webapps .. ");
            LOG.info((Object)("*** [ver." + HttpdVersionDef.getVersion() + " update." + HttpdVersionDef.getDate() + "]"));
            LOG.info((Object)"***");
            LOG.info((Object)"*** startupConfig....[START]");
            StartupConfig.init(path);
            LOG.info((Object)"*** startupConfig....[END]");
            LOG.info((Object)"*** startupHttpd.....[START]");
            StartupHttpdEngine.init(path);
            LOG.info((Object)"*** startupHttpd.....[END]");
            LOG.info((Object)"*** startupScript....[START]");
            ExecutionStartup.init();
            LOG.info((Object)"*** startupScript....[END]");
            LOG.info((Object)("### startup....[END:" + (System.currentTimeMillis() - tm) + "ms]"));
            ShutdownHook hook = ShutdownHook.registHook((ShutdownCallback)new ShutdownServer());
            WaitShutdown waitDown = new WaitShutdown(Startup.shutdownPort());
            while (!waitDown.isShutdown()) {
            }
            LOG.info((Object)"*** maachang comet - start shutdown ");
            hook.getShutdownCallback().execution();
            waitDown.exitShutdown();
            LOG.info((Object)"*** maachang comet - shutdown ..... end ");
        }
        catch (Exception e) {
            LOG.error((Object)"### error", (Throwable)e);
        }
    }

    private static final int shutdownPort() {
        String o;
        int ret = -1;
        GlobalManager nm = GlobalManager.getInstance();
        IniFile conf = (IniFile)nm.get("CONFIG_MANAGER");
        if (conf != null && (o = conf.get("server", "shutdown-port", 0)) != null) {
            try {
                ret = Integer.parseInt(o);
            }
            catch (Exception e) {
                ret = -1;
            }
        }
        return ret;
    }
}

