/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.comet.httpd.engine.HttpdEngine;
import org.maachang.comet.httpd.engine.HttpdPublicManager;
import org.maachang.comet.httpd.engine.HttpdScriptManager;
import org.maachang.comet.httpd.engine.comet.CometManager;
import org.maachang.comet.httpd.engine.errors.HttpdErrorPageManager;
import org.maachang.comet.httpd.engine.script.WebAppScriptFactory;
import org.maachang.comet.httpd.engine.script.dao.DaoFactory;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.comet.mdbm.SingleMDbm;
import org.maachang.comet.net.SslOption;
import org.maachang.conf.ConvIniParam;
import org.maachang.dbm.MDbm;
import org.maachang.manager.GlobalManager;
import org.maachang.session.client.local.PSessionLocalDriver;
import org.maachang.util.FileUtil;

public class StartupHttpdEngine {
    private static final Log LOG = LogFactory.getLog(StartupConfig.class);
    private static final String BASE_SECTION = "server";
    private static final String NET_SECTION = "net";

    private StartupHttpdEngine() {
    }

    public static final void init(String path) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        path = FileUtil.getFullPath((String)path);
        GlobalManager nm = GlobalManager.getInstance();
        IniFile conf = (IniFile)nm.get("CONFIG_MANAGER");
        LOG.info((Object)"$$$ ErrorManager .... [START]");
        HttpdErrorPageManager errors = new HttpdErrorPageManager(path);
        nm.put("ERROR_PAGE_MANAGER", (Object)errors);
        LOG.info((Object)"$$$ ErrorManager .... [END]");
        LOG.info((Object)"$$$ SessionManager .... [START]");
        HttpdSessionManager sessions = null;
        sessions = new HttpdSessionManager(PSessionLocalDriver.getConnection((MDbm)SingleMDbm.getInstance().getMDbm()));
        nm.put("SESSION_MANAGER", (Object)sessions);
        LOG.info((Object)"$$$ SessionManager .... [END]");
        LOG.info((Object)"$$$ CometManager .... [START]");
        int length = StartupHttpdEngine.getNumber(conf, "comet-pool");
        CometManager comet = null;
        comet = length <= 0 ? new CometManager() : new CometManager(length);
        nm.put("COMET_MANAGER", (Object)comet);
        LOG.info((Object)("$$$ CometManager .... [poolSize:" + comet.getPoolSize() + "]"));
        LOG.info((Object)"$$$ CometManager .... [END]");
        LOG.info((Object)"$$$ PublicManager .... [START]");
        HttpdPublicManager pubMan = new HttpdPublicManager(path);
        nm.put("PUBLIC_PAGE_MANAGER", (Object)pubMan);
        LOG.info((Object)"$$$ PublicManager .... [END]");
        LOG.info((Object)"$$$ WebAppScriptFactory .... [START]");
        WebAppScriptFactory webAppFactory = new WebAppScriptFactory(path);
        nm.put("WEBAPP_FACTORY", (Object)webAppFactory);
        LOG.info((Object)"$$$ WebAppScriptFactory .... [END]");
        LOG.info((Object)"$$$ ScriptManager .... [START]");
        HttpdScriptManager scripts = new HttpdScriptManager(path);
        nm.put("APPLICATION_PAGE_MANAGER", (Object)scripts);
        LOG.info((Object)"$$$ ScriptManager .... [END]");
        LOG.info((Object)"$$$ HttpdEngine(NET) .... [START]");
        int max = StartupHttpdEngine.getNumber(conf, NET_SECTION, "max-connect");
        int poolLen = StartupHttpdEngine.getNumber(conf, NET_SECTION, "max-pool");
        int port = StartupHttpdEngine.getNumber(conf, NET_SECTION, "server-port");
        InetAddress addr = StartupHttpdEngine.getInetAddress(conf, NET_SECTION, "server-address");
        if (max <= 0) {
            max = 100;
        }
        if (poolLen <= 0) {
            poolLen = 500;
        }
        if (port <= 0) {
            port = 3333;
        }
        SslOption sslOpt = SslOption.create(conf);
        LOG.info((Object)("$$$ HttpdEngine(NET) .... [max:" + max + " pool:" + poolLen + " port:" + port + " addr:" + addr + "]"));
        if (sslOpt == null) {
            LOG.info((Object)"$$$ HttpdEngine(NET) .... SSL\u306f\u7121\u52b9.");
        } else {
            LOG.info((Object)("$$$ HttpdEngine(NET) .... [SSL={" + sslOpt.toString() + "}]"));
        }
        HttpdEngine engine = new HttpdEngine(sslOpt, max, poolLen, port, addr);
        nm.put("HTTPD", (Object)engine);
        LOG.info((Object)"$$$ HttpdEngine(NET) .... [END]");
        LOG.info((Object)"$$$ DaoFactory .... [START]");
        DaoFactory daoFactory = new DaoFactory();
        nm.put("DAO_FACTORY", (Object)daoFactory);
        LOG.info((Object)"$$$ DaoFactory .... [END]");
    }

    public static final void destroy() {
        GlobalManager nm = GlobalManager.getInstance();
        LOG.info((Object)"$$$ (Destroy) HttpdEngine .... [START]");
        HttpdEngine engine = (HttpdEngine)nm.get("HTTPD");
        if (engine != null) {
            try {
                engine.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.info((Object)"$$$ (Destroy) HttpdEngine .... [END]");
    }

    protected static final long getTime(IniFile conf, String key) {
        return ConvIniParam.getLong((String)conf.get(BASE_SECTION, key, 0));
    }

    protected static final long getTime(IniFile conf, String section, String key) {
        return ConvIniParam.getLong((String)conf.get(section, key, 0));
    }

    protected static final boolean getBoolean(IniFile conf, String key) {
        return ConvIniParam.getBoolean((String)conf.get(BASE_SECTION, key, 0));
    }

    protected static final boolean getBoolean(IniFile conf, String section, String key) {
        return ConvIniParam.getBoolean((String)conf.get(section, key, 0));
    }

    protected static final int getNumber(IniFile conf, String key) {
        return ConvIniParam.getInt((String)conf.get(BASE_SECTION, key, 0));
    }

    protected static final int getNumber(IniFile conf, String section, String key) {
        return ConvIniParam.getInt((String)conf.get(section, key, 0));
    }

    protected static final InetAddress getInetAddress(IniFile conf, String key) {
        return ConvIniParam.getInetAddress((String)conf.get(BASE_SECTION, key, 0));
    }

    protected static final InetAddress getInetAddress(IniFile conf, String section, String key) {
        return ConvIniParam.getInetAddress((String)conf.get(section, key, 0));
    }
}

