/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.mdbm;

import java.net.InetAddress;
import org.maachang.comet.conf.IniFile;
import org.maachang.conf.ConvIniParam;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.client.MDbmDriverManager;
import org.maachang.manager.GlobalManager;

public class SingleMDbm {
    private MDbm mdbm = null;
    private static final SingleMDbm SNGL = new SingleMDbm();

    private SingleMDbm() {
    }

    public static final SingleMDbm getInstance() {
        return SNGL;
    }

    public boolean createMDbm(boolean console, boolean mode) throws Exception {
        return this.privateCreateMDbm(console, mode);
    }

    public MDbm getMDbm() throws Exception {
        return this.privateGetMDbm();
    }

    private synchronized boolean privateCreateMDbm(boolean console, boolean mode) throws Exception {
        if (this.mdbm == null) {
            if (!console) {
                this.mdbm = MDbmManager.getInstance().getMDbm(mode);
            } else {
                IniFile config = (IniFile)GlobalManager.getInstance().get("CONFIG_MANAGER");
                if (ConvIniParam.getBoolean((String)config.get("mdbm", "flag", 0))) {
                    InetAddress addr = ConvIniParam.getInetAddress((String)config.get("mdbm", "bind-addr", 0));
                    int port = ConvIniParam.getInt((String)config.get("mdbm", "bind-port", 0));
                    if (addr == null) {
                        addr = InetAddress.getByName("127.0.0.1");
                    }
                    if (port <= -1) {
                        port = -1;
                    }
                    this.mdbm = MDbmDriverManager.getConnection((InetAddress)addr, (int)port);
                }
            }
            return true;
        }
        return false;
    }

    private synchronized MDbm privateGetMDbm() {
        return this.mdbm;
    }
}

