package org.maachang.comet.httpd.engine;

import java.util.ArrayList;

import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;
import org.maachang.util.URLDecode;

/**
 * HTTPDユーティリティ.
 * 
 * @version 2007/08/19
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpdUtil {
    /**
     * URLの相対パスと、基本パスを合わせて、絶対パスを生成. <BR>
     * 
     * @param basePath
     *            対象の絶対パスを設定します
     * @param urlPath
     *            対象のURL相対パスを設定します.
     * @return String 絶対パスが返されます.
     * @exception Exception
     *                例外.
     */
    public static final String convertFullPath(String basePath, String urlPath)
            throws Exception {
        if (basePath.endsWith("/") == false && basePath.endsWith("\\") == false) {
            basePath += FileUtil.FILE_SPACE;
        }
        return FileUtil.getFullPath(basePath + urlPath) + FileUtil.FILE_SPACE;
    }
    
    /**
     * URLから、Query引数を取得. <BR>
     * <BR>
     * URLから、Query引数を取得します. <BR>
     * 
     * @param read
     *            変換元の名前を設定します.
     * @return String Queryが返されます.
     */
    public static final String getQueryValue(String read) {
        int len;
        int pnt;
        String ret = null;
        if (read == null || (len = read.length()) <= 0) {
            return "";
        }
        try {
            ret = ((pnt = read.indexOf("?")) != -1) ? read.substring(pnt + 1, len) : "";
        } catch (Exception e) {
            ret = "";
        }
        return ret;
    }
    
    /**
     * GET引数を含む読み込み名から、読み込み名のみ取得. <BR>
     * <BR>
     * GET引数を含む読み込み名から、読み込み名のみを取得します. <BR>
     * 
     * @param read
     *            変換元の名前を設定します.
     * @return String 読み込み名が返されます.
     */
    public static final String getReadName(String read) {
        int pnt;
        if (read == null || (read.length()) <= 0) {
            return "";
        }
        return ((pnt = read.indexOf("?")) != -1) ? read.substring(0, pnt)
                : read;
    }
    
    /**
     * Queryを解析して、HttpdParamsに設定. <BR>
     * <BR>
     * Queryを解析して、HttpdParamsに設定します. <BR>
     * 
     * @param out
     *            対象のHttpdParamsを設定します.
     * @param query
     *            対象のQueryを設定します.
     * @param charset
     *            対象のcharsetを設定します.
     */
    public static final void convertQueryByParams(HttpdParams out, String query,String charset) {
        try {
            ArrayList<String> lst = StringUtil.cutString(query, "&");
            if (lst != null && lst.size() > 0) {
                int len = lst.size();
                for (int i = 0; i < len; i++) {
                    String data = lst.get(i);
                    int p = data.indexOf("=");
                    if (p != -1) {
                        String key = data.substring(0, p);
                        String value = data.substring(p + 1, data.length());
                        value = URLDecode.convert( value,charset ) ;
                        out.addParam(key, value);
                    } else {
                        out.addParam(data, null);
                    }
                }
            }
        } catch( Exception e ) {
        }
    }

    
    /**
     * 読み込み対象日付がクライアントキャッシュ範囲内かチェック.
     * <BR><BR>
     * 読み込み対象日付がクライアントキャッシュ範囲内であるかチェックします.
     * <BR>
     * @param table 対象のHTTPヘッダを設定します.
     * @param time time 対象の最終ファイル更新時間を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、対象読み込み条件はキャッシュ範囲内です.<BR>
     *                 [false]が返された場合、対象読み込み条件はキャッシュ範囲外です.
     */
    public static final boolean isClientCache( HttpdHeaders header,long time ) {
        if( header == null ){
            return false ;
        }
        if( header.getHeader( HttpdDef.VALUE_CACHE_TIME ) != null ) {
            long src = HttpdTimestamp.convertTimestamp( header.getHeader( HttpdDef.VALUE_CACHE_TIME ) ) ;
            return ( src >= time ) ? true : false ;
        }
        return false ;
    }
    
}
