// I/Oスクリプト.
//


////////////////////////////////////////////////////////////////////////////////
// I/O系.
////////////////////////////////////////////////////////////////////////////////

// I/Oオブジェクト.
Io = function() {} ;

// 指定ディレクトリを生成.
Io.mkdir = function( dir ) {
    if( isNull( dir ) ) {
        return -1 ;
    }
    org.maachang.util.FileUtil.mkdirs( dir ) ;
} ;

// ファイル/ディレクトリを削除.
Io.deleteFile = function( fileName ) {
    if( isNull( fileName ) ) {
        return -1 ;
    }
    org.maachang.util.FileUtil.removeFile( fileName ) ;
} ;

// ファイルを移動.
Io.moveFile = function( src,dest ) {
    if( isNull( src ) || isNull( dest ) ) {
        return -1 ;
    }
    org.maachang.util.FileUtil.moveFile( src,dest ) ;
} ;

// ファイル長を取得.
Io.fileLength = function( fileName ) {
    if( isNull( fileName ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.getLength( fileName ) ;
} ;

// ファイル最終時間を取得.
Io.fileLastTime = function( fileName ) {
    if( isNull( fileName ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.getLastTime( fileName ) ;
} ;

// フルパス名を取得.
Io.getFullPath = function( fileName ) {
    if( isNull( fileName ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.getFullPath( fileName ) ;
} ;

// 指定パスからファイル名を取得.
Io.getFileName = function( fileName ) {
    if( isNull( fileName ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.getFileName( fileName ) ;
} ;

// 指定ファイルが存在するかチェック.
Io.isFileExists = function( name ) {
    if( isNull( name ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.isFileExists( name ) ;
} ;

// 指定ディレクトリが存在するかチェック.
Io.isDirExists = function( name ) {
    if( isNull( name ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.isDirExists( name ) ;
} ;

// 指定内容が読み込み可能かチェック.
Io.isReadFile = function( name ) {
    if( isNull( name ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.isRead( name ) ;
} ;

// 指定内容が書き込み可能かチェック.
Io.isWriteFile = function( name ) {
    if( isNull( name ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.isWrite( name ) ;
} ;

// 指定ディレクトリ以下の存在情報名を取得.
Io.getDirList = function( name ) {
    if( isNull( name ) ) {
        return -1 ;
    }
    var lst = org.maachang.util.FileUtil.getListByArray( name ) ;
    if( lst != null ) {
        return jlist( lst ) ;
    }
    return null ;
} ;

// ファイル内容をロード(String).
Io.readFileByString = function(fileName,charset) {
    if( isNull( fileName ) ) {
        return null ;
    }
    return org.maachang.util.FileUtil.getFileByString(
        fileName,(isNull(charset)) ? "UTF8" : charset );
} ;

// ファイル内容をロード(Binary).
Io.readFileByBinary = function(fileName) {
    if( isNull( fileName ) ) {
        return null ;
    }
    return org.maachang.util.FileUtil.getFile( fileName ) ;
} ;

// ファイル内容を保存(String).
Io.writeFileByString = function(mode,fileName,value,charset) {
    if( isNull( mode ) || isNull( fileName ) || isNull( value ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.setFileByString(
        fileName,mode,value,(isNull(charset)) ? "UTF8" : charset );
} ;

// ファイル内容を保存(Binary).
Io.writeFileBinary = function(mode,fileName,value) {
    if( isNull( mode ) || isNull( fileName ) || isNull( value ) ) {
        return -1 ;
    }
    return org.maachang.util.FileUtil.setFile( fileName,mode,value );
} ;

// 指定ファイルを実行.
Io.execution = function( name,charset ) {
    if( Io.isFileExists( name ) == false ) {
        return ;
    }
    var x = Io.readFileByString( name,charset ) ;
    return _eval( x ) ;
}

