// MaachangDbm操作用スクリプト.
//

// MDBMオブジェクト.
MDbm = function() {} ;

// データ追加.
MDbm.put = function( key,value ) {
    var mdbm = this.getMdbmObject() ;
    if( mdbm == null ) {
        return -1 ;
    }
    if( isNull( key ) || isNull( value ) ) {
        return -1 ;
    }
    if( valueof( key ) != "string" ) {
        if( valueof( key ) == "number" ) {
            key = ""+key ;
        }
        else {
            return -1 ;
        }
    }
    var bk = convertStringByBinary( key,"UTF8" ) ;
    var bf = new StrBuf() ;
    encodeJSON( value,bf ) ;
    var bv = convertStringByBinary( bf.toString(),"UTF8" ) ;
    bf = null ;
    mdbm.put( bk,bv ) ;
    return 0 ;
} ;

// データ削除.
MDbm.remove = function( key ) {
    var mdbm = this.getMdbmObject() ;
    if( mdbm == null ) {
        return -1 ;
    }
    if( isNull( key ) || valueof( key ) != "string" ) {
        if( valueof( key ) == "number" ) {
            key = ""+key ;
        }
        else {
            return -1 ;
        }
    }
    mdbm.remove( convertStringByBinary( key,"UTF8" ) ) ;
    return 0 ;
} ;

// データ取得.
MDbm.get = function( key ) {
    var mdbm = this.getMdbmObject() ;
    if( mdbm == null ) {
        return null ;
    }
    if( isNull( key ) || valueof( key ) != "string" ) {
        if( valueof( key ) == "number" ) {
            key = ""+key ;
        }
        else {
            return null ;
        }
    }
    var val = mdbm.get( convertStringByBinary( key,"UTF8" ) ) ;
    var ret = null ;
    if( isNull( val ) == false ) {
        ret = decodeJSON( ""+convertBinaryByString( val,"UTF8" ) ) ;
    }
    if( isNull( ret ) ) {
        return null ;
    }
    if( typeof( ret ) != "array" ) {
        ret = [ ret ] ;
    }
    return ret ;
}

// データ存在確認.
MDbm.containsKey = function( key ) {
    var mdbm = this.getMdbmObject() ;
    if( mdbm == null ) {
        return -1 ;
    }
    if( isNull( key ) || valueof( key ) != "string" ) {
        if( valueof( key ) == "number" ) {
            key = ""+key ;
        }
        else {
            return false ;
        }
    }
    return mdbm.containsKey( convertStringByBinary( key,"UTF8" ) ) ;
}

// シーケンスIDを取得.
MDbm.sequenceId = function( no ) {
    var mdbm = this.getMdbmObject() ;
    if( mdbm == null ) {
        return -1 ;
    }
    if( isNull( no ) || valueof( no ) != "number" || no <= 0 || no >= 64 ) {
        return -1 ;
    }
    return mdbm.sequenceId( no ) ;
}

// サイズ取得.
MDbm.size = function() {
    var mdbm = this.getMdbmObject() ;
    if( mdbm == null ) {
        return -1 ;
    }
    return mdbm.size() ;
}

// MDBMオブジェクトを取得.
MDbm.getMdbmObject = function() {
    var noModelFlag = false ;
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        noModelFlag = true ;
    }
    else if( script_model().getImageOp() == null ) {
        noModelFlag = true ;
    }
    if( noModelFlag == true ) {
        if(__$type$script != "console" ) {
            org.maachang.comet.mdbm.SingleMDbm.getInstance().createMDbm(false,false) ;
        }
        else {
            org.maachang.comet.mdbm.SingleMDbm.getInstance().createMDbm(true,false) ;
        }
    }
    return org.maachang.comet.mdbm.SingleMDbm.getInstance().getMDbm() ;
}

