package org.maachang.session.client.net ;

import java.net.InetAddress;

import org.maachang.connector.ClientConnector;
import org.maachang.session.client.PSessionManager;
import org.maachang.session.engine.PersistenceDefine;

/**
 * ネットワーク接続による、
 * クライアント永続化セッションドライバ.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class PSessionNetDriver {
    
    /**
     * タイムアウト値.
     */
    private static final int TIMEOUT = 30000 ;
    
    /**
     * 永続化セッションマネージャを取得.
     * @return PSessionManager 永続化セッションマネージャが返されます.
     * @exception Exception 例外.
     */
    public static final PSessionManager getConnection() throws Exception {
        return getConnection( null,-1 ) ;
    }
    
    /**
     * 永続化セッションマネージャを取得.
     * @param addr 接続先アドレスを設定します.
     * @return PSessionManager 永続化セッションマネージャが返されます.
     * @exception Exception 例外.
     */
    public static final PSessionManager getConnection( InetAddress addr ) throws Exception {
        return getConnection( addr,-1)  ;
    }
    
    /**
     * 永続化セッションマネージャを取得.
     * @param addr 接続先アドレスを設定します.
     * @param port 接続先ポート番号を設定します.
     * @return PSessionManager 永続化セッションマネージャが返されます.
     * @exception Exception 例外.
     */
    public static final PSessionManager getConnection( InetAddress addr,int port ) throws Exception {
        if( addr == null ) {
            addr = InetAddress.getByName( "127.0.0.1" ) ;
        }
        if( port <= -1 || port >= 65536 ) {
            port = PersistenceDefine.BIND_PORT ;
        }
        ClientConnector conn = new ClientConnector( PersistenceDefine.PROTOCOL_HEADER,
            addr,port,TIMEOUT ) ;
        return new PSessionNetManagerImpl( conn ) ;
    }
}

