package org.maachang.session.client.net.protocol ;

import org.maachang.session.engine.PersistenceDefine;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションID存在要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class ClUseSessionIdProtocol extends ClientProtocol {
    
    /**
     * 問合せセッションID.
     */
    private String sessionId = null ;
    
    /**
     * コンストラクタ.
     */
    public ClUseSessionIdProtocol() {
    }
    
    /**
     * オブジェクト生成.
     */
    public void create( String sessionId )
        throws Exception {
        if( sessionId == null ||
            ( sessionId = sessionId.trim() ).length() != PersistenceDefine.SESSION_KEY_LENGTH ) {
            throw new IllegalArgumentException( "指定されたセッションIDは不正です" ) ;
        }
        this.sessionId = sessionId ;
    }
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        super.clear() ;
        sessionId = null ;
    }
    
    /**
     * クライアントプロトコルタイプを取得.
     * @return int クライアントプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_USE_SESSION_ID ;
    }
    
    /**
     * 問合せセッションIDを取得.
     * @return String 問合せセッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 送信データを作成.
     * @return value 送信データが返されます.
     * @exception Exception 例外.
     */
    public byte[] getSendData() throws Exception {
        byte[] valBin = sessionId.getBytes( "UTF8" ) ;
        ArrayBinary b = new ArrayBinary( 60 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        b.write( ConvertParam.convertInt( valBin.length ) ) ;
        b.write( valBin ) ;
        return b.getBinary() ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @param p オフセット値を設定します.
     */
    public void setResult( byte[] value,int p ) throws Exception {
        this.result = new Boolean( ( value[ p ] == 1 ) ? true : false ) ;
    }
}

