/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.service.KeySessionChild;
import org.maachang.dbm.service.KeySessionMonThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeySessionManager {
    private static final long TIME = 180000L;
    private Map<Long, KeySessionChild> map = Collections.synchronizedMap(new HashMap());
    private KeySessionMonThread thread = new KeySessionMonThread(this.map, 180000L);

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread.stopThread();
        }
        this.thread = null;
        this.map = null;
    }

    public synchronized void remove(long id) throws Exception {
        MDbm mdbm;
        KeySessionChild ch = this.map.remove(new Long(id));
        if (ch != null && (mdbm = ch.getMDbm()) != null) {
            try {
                mdbm.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdbm.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void putMDbm(long id, MDbm value) throws Exception {
        if (id <= 0L || value == null || !value.isUse()) {
            throw new IllegalArgumentException("\u30bb\u30c3\u30b7\u30e7\u30f3\u767b\u9332\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Long key = new Long(id);
        KeySessionChild ch = this.map.get(key);
        if (ch == null) {
            ch = new KeySessionChild();
            this.map.put(key, ch);
        }
        ch.setMDbm(value);
    }

    public synchronized void removeMDbm(long id) throws Exception {
        KeySessionChild ch = this.map.get(new Long(id));
        if (ch != null) {
            MDbm mdbm = ch.getMDbm();
            if (mdbm != null) {
                try {
                    mdbm.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    mdbm.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ch.setMDbm(null);
        }
    }

    public synchronized MDbm getMDbm(long id) throws Exception {
        KeySessionChild ch = this.map.get(new Long(id));
        if (ch == null) {
            return null;
        }
        return ch.getMDbm();
    }

    public synchronized void putKey(long id, Enumeration<byte[]> value) throws Exception {
        if (id <= 0L || value == null) {
            throw new IllegalArgumentException("\u30bb\u30c3\u30b7\u30e7\u30f3\u767b\u9332\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Long key = new Long(id);
        KeySessionChild ch = this.map.get(key);
        if (ch == null) {
            ch = new KeySessionChild();
            this.map.put(key, ch);
        }
        ch.setKey(value);
    }

    public synchronized void removeKey(long id) throws Exception {
        KeySessionChild ch = this.map.get(new Long(id));
        if (ch != null) {
            ch.setKey(null);
        }
    }

    public synchronized Enumeration<byte[]> getKey(long id) throws Exception {
        KeySessionChild ch = this.map.get(new Long(id));
        if (ch == null) {
            return null;
        }
        return ch.getKey();
    }
}

