/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorManager;
import org.maachang.connector.ConnectorService;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.MDbmCallback;
import org.maachang.dbm.service.ProtocolDef;

public class MDbmServerService {
    private static final Log LOG = LogFactory.getLog(MDbmServerService.class);
    private ConnectorService service = null;

    private MDbmServerService() {
    }

    public MDbmServerService(InetAddress addr, int port, int max, int pool) throws Exception {
        this.createObject(addr, port, max, pool);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.service != null) {
            LOG.info((Object)"## MDbmServerService - \u7834\u68c4");
            this.service.destroy();
        }
    }

    private void createObject(InetAddress addr, int port, int max, int pool) throws Exception {
        ConnectorService sv;
        if (MDbmManager.getInstance().isClose()) {
            throw new IOException("MaachangDbm\u306f\u958b\u59cb\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        if (port <= -1 || port >= 65536) {
            port = 3953;
        }
        if (max <= 0) {
            max = 30;
        }
        if (pool <= 0) {
            pool = 15;
        }
        if (addr != null) {
            LOG.info((Object)("## MDbmServerService - \u751f\u6210[ addr:" + addr.getHostAddress() + " port:" + port + " max:" + max + " pool:" + pool + "]"));
        } else {
            LOG.info((Object)("## MDbmServerService - \u751f\u6210[ addr:0.0.0.0 port:" + port + " max:" + max + " pool:" + pool + "]"));
        }
        ConnectorManager man = new ConnectorManager(addr, port, max);
        MDbmCallback call = new MDbmCallback(MDbmManager.getInstance().getMDbm(false));
        this.service = sv = new ConnectorService(ProtocolDef.PROTOCOL_HEADER, (ConnectorCallback)call, man, pool);
    }
}

