/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.Serializable;

public class Roll
implements Serializable {
    private static final long serialVersionUID = 8691857712645177084L;
    private Object[] roll = null;
    private int max = 0;
    private int now = 0;
    private int nowLen = 0;

    private Roll() {
    }

    public Roll(int max) throws Exception {
        if (max <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object[] roll = null;
        roll = new Object[max];
        int i = 0;
        while (i < max) {
            roll[i] = null;
            ++i;
        }
        this.roll = roll;
        this.max = max;
        this.now = 0;
        this.nowLen = 0;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        Object[] roll = null;
        int len = this.max;
        if (len > 0) {
            roll = this.roll;
            int i = 0;
            while (i < len) {
                roll[i] = null;
                ++i;
            }
        }
        this.roll = null;
        this.max = 0;
        this.now = 0;
        this.nowLen = 0;
    }

    public final boolean add(Object value) throws Exception {
        return this.addTo(false, value);
    }

    public final boolean addHead(Object value) throws Exception {
        return this.addTo(true, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() {
        Object ret = null;
        Roll roll = this;
        synchronized (roll) {
            if (this.nowLen <= 0) {
                ret = null;
            } else {
                int pnt = this.now - this.nowLen;
                if (pnt < 0) {
                    pnt = this.max + pnt;
                }
                ret = this.roll[pnt];
                this.roll[pnt] = null;
                --this.nowLen;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object reference(int no) {
        Object ret = null;
        Roll roll = this;
        synchronized (roll) {
            if (this.nowLen <= 0) {
                ret = null;
            } else {
                int pnt = this.now + no - this.nowLen;
                if (pnt < 0) {
                    pnt = this.max + pnt;
                }
                ret = this.roll[pnt];
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMax() {
        int ret;
        Roll roll = this;
        synchronized (roll) {
            ret = this.max;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int ret;
        Roll roll = this;
        synchronized (roll) {
            ret = this.nowLen;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAdd() {
        boolean ret;
        Roll roll = this;
        synchronized (roll) {
            if (this.nowLen >= this.max) {
                boolean bl = false;
            }
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, Object value) throws Exception {
        boolean ret = false;
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Roll roll = this;
        synchronized (roll) {
            if (this.nowLen >= this.max) {
                ret = false;
            } else {
                int next = this.getAddPoint(hlMode);
                this.roll[next] = null;
                this.roll[next] = value;
                ret = true;
            }
        }
        return ret;
    }

    private final int getAddPoint(boolean hlMode) {
        int ret = this.now;
        if (hlMode) {
            if (this.nowLen > 0) {
                ret = this.now - this.nowLen;
                if (ret < 0) {
                    ret = this.max + ret;
                }
                if (--ret < 0) {
                    ret = this.max - 1;
                }
            } else {
                if (ret >= this.max) {
                    ret = 0;
                }
                this.now = ret + 1;
            }
            ++this.nowLen;
        } else {
            if (ret >= this.max) {
                ret = 0;
            }
            ++this.nowLen;
            this.now = ret + 1;
        }
        return ret;
    }
}

