/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.conf.Config;
import org.maachang.session.PSessionShutdown;
import org.maachang.session.engine.PersistenceService;
import org.maachang.session.server.PSessionServerService;
import org.maachang.shutdown.ShutdownCallback;
import org.maachang.shutdown.ShutdownHook;
import org.maachang.shutdown.WaitShutdown;

public class PSessionProcess {
    private static final Log LOG = LogFactory.getLog(PSessionProcess.class);
    private PSessionServerService serverService = null;

    private PSessionProcess() {
    }

    public static final void main(String[] args) throws Exception {
        new PSessionProcess().execution();
    }

    private void execution() throws Exception {
        LOG.info((Object)"*** [PSession] startup[version:b1.00] ***");
        PersistenceService.getInstance().init();
        this.serverService = new PSessionServerService();
        int port = PSessionProcess.getShutdownPort();
        ShutdownHook.registHook((ShutdownCallback)new PSessionShutdown(this.serverService));
        WaitShutdown waitDown = new WaitShutdown(port);
        LOG.info((Object)"*** [PSession] startup...[OK]");
        while (!waitDown.isShutdown()) {
        }
        waitDown.exitShutdown();
    }

    public static final int getShutdownPort() throws Exception {
        Config conf = PSessionServerService.readConfig();
        int port = conf.getInt("session", "shutdown-port", 0);
        if (port <= 0) {
            port = 3101;
        }
        return port;
    }
}

