/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.maachang.session.engine.CacheChild;

class CacheValue {
    private long lastMod = System.currentTimeMillis();
    private List<CacheChild> values = Collections.synchronizedList(new ArrayList());

    protected CacheValue() {
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.lastMod = -1L;
        this.values = null;
    }

    protected int search(String key) {
        int len = this.values.size();
        int i = 0;
        while (i < len) {
            CacheChild ch = this.values.get(i);
            if (ch != null && key.equals(ch.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private synchronized long getLastMod() {
        return this.lastMod;
    }

    private synchronized void updateLastMod() {
        this.lastMod = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, byte[] value) {
        if (key == null || (key = key.trim()).length() <= 0 || value == null || value.length <= 0) {
            return;
        }
        CacheValue cacheValue = this;
        synchronized (cacheValue) {
            int n = this.search(key);
            if (n <= -1) {
                CacheChild ch = new CacheChild(key, value);
                this.values.add(ch);
            } else {
                this.values.get(n).setValue(value);
            }
            this.updateLastMod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        CacheValue cacheValue = this;
        synchronized (cacheValue) {
            int n = this.search(key);
            if (n >= 0) {
                this.values.remove(n);
            }
            this.updateLastMod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int no) {
        if (no <= -1 || no >= this.values.size()) {
            return;
        }
        CacheValue cacheValue = this;
        synchronized (cacheValue) {
            this.values.remove(no);
            this.updateLastMod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return null;
        }
        byte[] ret = null;
        CacheValue cacheValue = this;
        synchronized (cacheValue) {
            int n = this.search(key);
            if (n >= 0) {
                ret = this.values.get(n).getValue();
            }
            this.updateLastMod();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] get(int no) {
        if (no <= -1 || no >= this.values.size()) {
            return null;
        }
        byte[] ret = null;
        CacheValue cacheValue = this;
        synchronized (cacheValue) {
            CacheChild ch = this.values.get(no);
            if (ch != null) {
                ret = ch.getValue();
            }
            this.updateLastMod();
        }
        return ret;
    }

    public boolean containsKey(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return false;
        }
        return this.search(key) >= 0;
    }

    public int size() {
        return this.values.size();
    }

    public long getLastTime() {
        return this.getLastMod();
    }
}

