package org.maachang.session.client.net.protocol ;

import org.maachang.util.ConvertParam;

/**
 * セッション削除時間要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class ClDeleteSessionTimeProtocol extends ClientProtocol {
    
    /**
     * コンストラクタ.
     */
    public ClDeleteSessionTimeProtocol() {
    }
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        super.clear() ;
    }
    
    /**
     * クライアントプロトコルタイプを取得.
     * @return int クライアントプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_DELETE_SESSION_TIME ;
    }
    
    /**
     * 送信データを作成.
     * @return value 送信データが返されます.
     * @exception Exception 例外.
     */
    public byte[] getSendData() throws Exception {
        return ConvertParam.convertInt( getProtocolType() ) ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @param p オフセット値を設定します.
     */
    public void setResult( byte[] value,int p ) throws Exception {
        this.result = new Long( ConvertParam.convertLong( p,value ) ) ;
    }
}

