package org.maachang.session.client.net.protocol ;

import org.maachang.session.engine.PersistenceDefine;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * 指定セッションID非存在時に新規作成.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class ClUseToSessionIdProtocol extends ClientProtocol {
    
    /**
     * 問合せセッションID.
     */
    private String sessionId = null ;
    
    /**
     * コンストラクタ.
     */
    public ClUseToSessionIdProtocol() {
    }
    
    /**
     * オブジェクト生成.
     */
    public void create( String sessionId )
        throws Exception {
        if( sessionId == null ||
            ( sessionId = sessionId.trim() ).length() != PersistenceDefine.SESSION_KEY_LENGTH ) {
            this.sessionId = null ;
        }
        else {
            this.sessionId = sessionId ;
        }
    }
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        super.clear() ;
        sessionId = null ;
    }
    
    /**
     * クライアントプロトコルタイプを取得.
     * @return int クライアントプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_USE_TO_SESSOIN_ID ;
    }
    
    /**
     * 問合せセッションIDを取得.
     * @return String 問合せセッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 送信データを作成.
     * @return value 送信データが返されます.
     * @exception Exception 例外.
     */
    public byte[] getSendData() throws Exception {
        ArrayBinary b = new ArrayBinary( 60 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        byte[] valBin = null ;
        int len = -1 ;
        if( sessionId != null ) {
            valBin = sessionId.getBytes( "UTF8" ) ;
            len = valBin.length ;
        }
        b.write( ConvertParam.convertInt( len ) ) ;
        if( valBin != null ) {
            b.write( valBin ) ;
        }
        return b.getBinary() ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @param p オフセット値を設定します.
     */
    public void setResult( byte[] value,int p ) throws Exception {
        int len = ConvertParam.convertInt( p,value ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( value,p,b,0,len ) ;
            this.result = new String( b,"UTF8" ) ;
            p += len ;
        }
    }
}

